/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs.watcher;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.watcher.FileWatchEventListener;
import org.neo4j.io.fs.watcher.FileWatchEventListenerFactory;
import org.neo4j.io.fs.watcher.FileWatcher;
import org.neo4j.io.fs.watcher.resource.WatchedResource;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class DatabaseLayoutWatcher
extends LifecycleAdapter {
    private final FileWatcher fileWatcher;
    private final DatabaseLayout databaseLayout;
    private final FileWatchEventListenerFactory listenerFactory;
    private final Set<File> filesToWatch = ConcurrentHashMap.newKeySet();
    private final Set<WatchedResource> watchedResources = ConcurrentHashMap.newKeySet();
    private FileWatchEventListener eventListener;

    public DatabaseLayoutWatcher(FileWatcher fileWatcher, DatabaseLayout databaseLayout, FileWatchEventListenerFactory listenerFactory) {
        Objects.requireNonNull(fileWatcher);
        Objects.requireNonNull(databaseLayout);
        Objects.requireNonNull(listenerFactory);
        this.fileWatcher = fileWatcher;
        this.databaseLayout = databaseLayout;
        this.listenerFactory = listenerFactory;
    }

    public void start() throws Exception {
        this.watchDirectories();
        this.eventListener = this.listenerFactory.createListener(this.watchedResources);
        this.fileWatcher.addFileWatchEventListener(this.eventListener);
    }

    public void stop() throws Exception {
        this.stopWatching();
        this.fileWatcher.removeFileWatchEventListener(this.eventListener);
    }

    private void watchDirectories() {
        Neo4jLayout layout = this.databaseLayout.getNeo4jLayout();
        this.watch(this.databaseLayout.databaseDirectory());
        this.watch(this.databaseLayout.getTransactionLogsDirectory());
        this.watch(layout.databasesDirectory());
        this.watch(layout.transactionLogsRootDirectory());
        this.watch(layout.homeDirectory());
        this.startWatching();
    }

    private void watch(File file) {
        this.filesToWatch.add(file);
    }

    private void stopWatching() {
        try {
            IOUtils.closeAll(this.watchedResources);
            this.watchedResources.clear();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void startWatching() {
        for (File fileToWatch : this.filesToWatch) {
            this.watchFile(fileToWatch);
        }
    }

    private void watchFile(File fileToWatch) {
        try {
            this.watchedResources.add(this.fileWatcher.watch(fileToWatch));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

