/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.internal;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.neo4j.logging.Logger;
import org.neo4j.logging.internal.DatabaseLogContext;

public class DatabaseLogger
implements Logger {
    private final DatabaseLogContext logContext;
    private final Supplier<Logger> delegate;

    DatabaseLogger(DatabaseLogContext logContext, Supplier<Logger> delegate) {
        this.logContext = logContext;
        this.delegate = delegate;
    }

    @Override
    public void log(@Nonnull String message) {
        this.delegate.get().log(this.withPrefix(message));
    }

    @Override
    public void log(@Nonnull String message, @Nonnull Throwable throwable) {
        this.delegate.get().log(this.withPrefix(message), throwable);
    }

    @Override
    public void log(@Nonnull String format, Object ... arguments) {
        this.delegate.get().log(this.withPrefix(format), arguments);
    }

    @Override
    public void bulk(@Nonnull Consumer<Logger> consumer) {
        this.delegate.get().bulk(logger -> consumer.accept(new DatabaseLogger(this.logContext, () -> logger)));
    }

    private String withPrefix(String message) {
        if (this.logContext != null) {
            return this.logContext.formatMessage(message);
        }
        return message;
    }
}

