/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.SnapshotDeletionPolicy;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.api.impl.index.LuceneIndexWriter;

public class LuceneSnapshotter {
    private static final String NO_INDEX_COMMIT_TO_SNAPSHOT = "No index commit to snapshot";
    private static final String ID = "backup";

    ResourceIterator<File> snapshot(File indexDir, LuceneIndexWriter writer) throws IOException {
        SnapshotDeletionPolicy deletionPolicy = (SnapshotDeletionPolicy)writer.getIndexDeletionPolicy();
        try {
            return new LuceneSnapshotIterator(indexDir, deletionPolicy.snapshot(ID), deletionPolicy);
        }
        catch (IllegalStateException e) {
            if (e.getMessage().equals(NO_INDEX_COMMIT_TO_SNAPSHOT)) {
                return IteratorUtil.emptyIterator();
            }
            throw e;
        }
    }

    private class LuceneSnapshotIterator
    extends PrefetchingIterator<File>
    implements ResourceIterator<File> {
        private final File indexDirectory;
        private final SnapshotDeletionPolicy deletionPolicy;
        private final Iterator<String> fileNames;

        LuceneSnapshotIterator(File indexDirectory, IndexCommit snapshotPoint, SnapshotDeletionPolicy deletionPolicy) throws IOException {
            this.indexDirectory = indexDirectory;
            this.deletionPolicy = deletionPolicy;
            this.fileNames = snapshotPoint.getFileNames().iterator();
        }

        protected File fetchNextOrNull() {
            if (!this.fileNames.hasNext()) {
                return null;
            }
            return new File(this.indexDirectory, this.fileNames.next());
        }

        public void close() {
            try {
                this.deletionPolicy.release(LuceneSnapshotter.ID);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to close lucene index snapshot", e);
            }
        }
    }
}

