/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.impl.index.LuceneAllDocumentsReader;
import org.neo4j.kernel.api.impl.index.LucenePartitionAllDocumentsReader;
import org.neo4j.kernel.api.impl.index.WritableAbstractDatabaseIndex;
import org.neo4j.kernel.api.impl.index.partition.AbstractIndexPartition;
import org.neo4j.kernel.api.impl.index.partition.IndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.kernel.api.impl.schema.writer.PartitionedIndexWriter;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexReader;

public abstract class AbstractLuceneIndex<READER extends IndexReader> {
    private static final String KEY_STATUS = "status";
    private static final String ONLINE = "online";
    private static final Map<String, String> ONLINE_COMMIT_USER_DATA = Collections.singletonMap("status", "online");
    protected final PartitionedIndexStorage indexStorage;
    protected final IndexDescriptor descriptor;
    private final IndexPartitionFactory partitionFactory;
    private CopyOnWriteArrayList<AbstractIndexPartition> partitions = new CopyOnWriteArrayList();
    private volatile boolean open;

    public AbstractLuceneIndex(PartitionedIndexStorage indexStorage, IndexPartitionFactory partitionFactory, IndexDescriptor descriptor) {
        this.indexStorage = indexStorage;
        this.partitionFactory = partitionFactory;
        this.descriptor = descriptor;
    }

    public void create() throws IOException {
        this.ensureNotOpen();
        this.indexStorage.prepareFolder(this.indexStorage.getIndexFolder());
        this.indexStorage.reserveIndexFailureStorage();
        this.createNewPartitionFolder();
    }

    public void open() throws IOException {
        Set<Map.Entry<File, Directory>> indexDirectories = this.indexStorage.openIndexDirectories().entrySet();
        ArrayList<AbstractIndexPartition> list = new ArrayList<AbstractIndexPartition>(indexDirectories.size());
        for (Map.Entry<File, Directory> entry : indexDirectories) {
            list.add(this.partitionFactory.createPartition(entry.getKey(), entry.getValue()));
        }
        this.partitions.addAll(list);
        this.open = true;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean exists() throws IOException {
        List<File> folders = this.indexStorage.listFolders();
        if (folders.isEmpty()) {
            return false;
        }
        for (File folder : folders) {
            if (this.luceneDirectoryExists(folder)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        if (this.open) {
            return true;
        }
        Collection<Directory> directories = null;
        try {
            directories = this.indexStorage.openIndexDirectories().values();
            for (Directory directory : directories) {
                if (ArrayUtil.isEmpty((Object[])directory.listAll())) continue;
                CheckIndex checker = new CheckIndex(directory);
                Throwable throwable = null;
                try {
                    CheckIndex.Status status = checker.checkIndex();
                    if (status.clean) continue;
                    boolean bl = false;
                    return bl;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (checker == null) continue;
                    if (throwable != null) {
                        try {
                            checker.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    checker.close();
                }
            }
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.closeAllSilently(directories);
        }
        return true;
    }

    public LuceneIndexWriter getIndexWriter(WritableAbstractDatabaseIndex writableAbstractDatabaseIndex) {
        this.ensureOpen();
        return new PartitionedIndexWriter(writableAbstractDatabaseIndex);
    }

    public READER getIndexReader() throws IOException {
        this.ensureOpen();
        List<AbstractIndexPartition> partitions = this.getPartitions();
        return this.hasSinglePartition(partitions) ? this.createSimpleReader(partitions) : this.createPartitionedReader(partitions);
    }

    public IndexDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void drop() {
        try {
            this.close();
            this.indexStorage.cleanupFolder(this.indexStorage.getIndexFolder());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void flush(boolean merge) throws IOException {
        List<AbstractIndexPartition> partitions = this.getPartitions();
        for (AbstractIndexPartition partition : partitions) {
            IndexWriter writer = partition.getIndexWriter();
            writer.commit();
            if (!merge) continue;
            writer.forceMerge(1);
        }
    }

    public void close() throws IOException {
        this.open = false;
        IOUtils.closeAll(this.partitions);
        this.partitions.clear();
    }

    public LuceneAllDocumentsReader allDocumentsReader() {
        this.ensureOpen();
        ArrayList<PartitionSearcher> searchers = new ArrayList<PartitionSearcher>(this.partitions.size());
        try {
            for (AbstractIndexPartition partition : this.partitions) {
                searchers.add(partition.acquireSearcher());
            }
            List<LucenePartitionAllDocumentsReader> partitionReaders = searchers.stream().map(LucenePartitionAllDocumentsReader::new).collect(Collectors.toList());
            return new LuceneAllDocumentsReader(partitionReaders);
        }
        catch (IOException e) {
            IOUtils.closeAllSilently(searchers);
            throw new UncheckedIOException(e);
        }
    }

    public ResourceIterator<File> snapshot() throws IOException {
        this.ensureOpen();
        ArrayList<ResourceIterator<File>> snapshotIterators = null;
        try {
            List<AbstractIndexPartition> partitions = this.getPartitions();
            snapshotIterators = new ArrayList<ResourceIterator<File>>(partitions.size());
            for (AbstractIndexPartition partition : partitions) {
                snapshotIterators.add(partition.snapshot());
            }
            return Iterators.concatResourceIterators(snapshotIterators.iterator());
        }
        catch (Exception e) {
            if (snapshotIterators != null) {
                try {
                    IOUtils.closeAll(snapshotIterators);
                }
                catch (IOException ex) {
                    e.addSuppressed(ex);
                }
            }
            throw e;
        }
    }

    public void maybeRefreshBlocking() throws IOException {
        try {
            this.getPartitions().parallelStream().forEach(this::maybeRefreshPartition);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private void maybeRefreshPartition(AbstractIndexPartition partition) {
        try {
            partition.maybeRefreshBlocking();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public List<AbstractIndexPartition> getPartitions() {
        this.ensureOpen();
        return this.partitions;
    }

    public boolean hasSinglePartition(List<AbstractIndexPartition> partitions) {
        return partitions.size() == 1;
    }

    public AbstractIndexPartition getFirstPartition(List<AbstractIndexPartition> partitions) {
        return partitions.get(0);
    }

    AbstractIndexPartition addNewPartition() throws IOException {
        this.ensureOpen();
        File partitionFolder = this.createNewPartitionFolder();
        Directory directory = this.indexStorage.openDirectory(partitionFolder);
        AbstractIndexPartition indexPartition = this.partitionFactory.createPartition(partitionFolder, directory);
        this.partitions.add(indexPartition);
        return indexPartition;
    }

    protected void ensureOpen() {
        if (!this.open) {
            throw new IllegalStateException("Please open lucene index before working with it.");
        }
    }

    protected void ensureNotOpen() {
        if (this.open) {
            throw new IllegalStateException("Lucene index should not be open to be able to perform required operation.");
        }
    }

    protected static List<PartitionSearcher> acquireSearchers(List<AbstractIndexPartition> partitions) throws IOException {
        ArrayList<PartitionSearcher> searchers = new ArrayList<PartitionSearcher>(partitions.size());
        try {
            for (AbstractIndexPartition partition : partitions) {
                searchers.add(partition.acquireSearcher());
            }
            return searchers;
        }
        catch (IOException e) {
            IOUtils.closeAllSilently(searchers);
            throw e;
        }
    }

    private boolean luceneDirectoryExists(File folder) throws IOException {
        try (Directory directory = this.indexStorage.openDirectory(folder);){
            boolean bl = DirectoryReader.indexExists((Directory)directory);
            return bl;
        }
    }

    private File createNewPartitionFolder() throws IOException {
        File partitionFolder = this.indexStorage.getPartitionFolder(this.partitions.size() + 1);
        this.indexStorage.prepareFolder(partitionFolder);
        return partitionFolder;
    }

    public boolean isOnline() throws IOException {
        this.ensureOpen();
        AbstractIndexPartition partition = this.getFirstPartition(this.getPartitions());
        Directory directory = partition.getDirectory();
        try (DirectoryReader reader = DirectoryReader.open((Directory)directory);){
            Map userData = reader.getIndexCommit().getUserData();
            boolean bl = ONLINE.equals(userData.get(KEY_STATUS));
            return bl;
        }
    }

    public void markAsOnline() throws IOException {
        this.ensureOpen();
        AbstractIndexPartition partition = this.getFirstPartition(this.getPartitions());
        IndexWriter indexWriter = partition.getIndexWriter();
        indexWriter.setCommitData(ONLINE_COMMIT_USER_DATA);
        this.flush(false);
    }

    public void markAsFailed(String failure) throws IOException {
        this.indexStorage.storeIndexFailure(failure);
    }

    protected abstract READER createSimpleReader(List<AbstractIndexPartition> var1) throws IOException;

    protected abstract READER createPartitionedReader(List<AbstractIndexPartition> var1) throws IOException;
}

