/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.reader;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.values.storable.Value;

class LuceneDistinctValuesProgressor
implements IndexProgressor {
    private final TermsEnum terms;
    private final IndexProgressor.EntityValueClient client;
    private final Function<BytesRef, Value> valueMaterializer;

    LuceneDistinctValuesProgressor(TermsEnum terms, IndexProgressor.EntityValueClient client, Function<BytesRef, Value> valueMaterializer) throws IOException {
        this.terms = terms;
        this.client = client;
        this.valueMaterializer = valueMaterializer;
    }

    public boolean next() {
        try {
            while (this.terms.next() != null) {
                if (!this.client.acceptEntity((long)this.terms.docFreq(), Float.NaN, new Value[]{this.valueMaterializer.apply(this.terms.term())})) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void close() {
    }
}

