/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.http.driver;

import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.neo4j.ogm.driver.AbstractConfigurableDriver;
import org.neo4j.ogm.drivers.http.request.HttpRequest;
import org.neo4j.ogm.drivers.http.transaction.HttpTransaction;
import org.neo4j.ogm.exception.ResultProcessingException;
import org.neo4j.ogm.request.Request;
import org.neo4j.ogm.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpDriver
extends AbstractConfigurableDriver {
    private static final int CPUS = Runtime.getRuntime().availableProcessors();
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpDriver.class);
    private CloseableHttpClient httpClient;

    public HttpDriver() {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(CPUS);
        connectionManager.setDefaultMaxPerRoute(CPUS);
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        this.initialise(httpClient);
    }

    public HttpDriver initialise(CloseableHttpClient httpClient) {
        if (this.httpClient != null) {
            this.close();
        }
        this.httpClient = httpClient;
        return this;
    }

    public synchronized void close() {
        try {
            LOGGER.info("Shutting down Http driver {} ", (Object)this);
            this.httpClient.close();
        }
        catch (Exception e) {
            LOGGER.warn("Unexpected Exception when closing http client httpClient: ", (Throwable)e);
        }
    }

    public Request request() {
        String url = this.requestUrl();
        return new HttpRequest(this.httpClient, url, this.driverConfig.getCredentials());
    }

    public Transaction newTransaction() {
        String url = this.newTransactionUrl();
        return new HttpTransaction(this.transactionManager, this, url);
    }

    /*
     * Exception decompiling
     */
    public CloseableHttpResponse executeHttpRequest(HttpRequestBase request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String newTransactionUrl() {
        String url = this.transactionEndpoint(this.driverConfig.getURI());
        LOGGER.debug("Thread {}: POST {}", (Object)Thread.currentThread().getId(), (Object)url);
        try (CloseableHttpResponse response = this.executeHttpRequest((HttpRequestBase)new HttpPost(url));){
            Header location = response.getHeaders("Location")[0];
            response.close();
            String string = location.getValue();
            return string;
        }
        catch (Exception e) {
            throw new ResultProcessingException("Could not obtain new Transaction: ", e);
        }
    }

    private String autoCommitUrl() {
        return this.transactionEndpoint(this.driverConfig.getURI()).concat("/commit");
    }

    private String transactionEndpoint(String server) {
        if (server == null) {
            return null;
        }
        String url = server;
        if (!server.endsWith("/")) {
            url = url + "/";
        }
        return url + "db/data/transaction";
    }

    private String requestUrl() {
        if (this.transactionManager != null) {
            Transaction tx = this.transactionManager.getCurrentTransaction();
            if (tx != null) {
                LOGGER.debug("Thread {}: request url {}", (Object)Thread.currentThread().getId(), (Object)((HttpTransaction)tx).url());
                return ((HttpTransaction)tx).url();
            }
            LOGGER.debug("Thread {}: No current transaction, using auto-commit", (Object)Thread.currentThread().getId());
        } else {
            LOGGER.debug("Thread {}: No transaction manager available, using auto-commit", (Object)Thread.currentThread().getId());
        }
        LOGGER.debug("Thread {}: request url {}", (Object)Thread.currentThread().getId(), (Object)this.autoCommitUrl());
        return this.autoCommitUrl();
    }
}

