/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.autoindex;

import java.util.List;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.ogm.autoindex.BaseAutoIndexManagerTestClass;
import org.neo4j.ogm.domain.autoindex.CompositeIndexChild;
import org.neo4j.ogm.domain.autoindex.CompositeIndexEntity;
import org.neo4j.ogm.domain.autoindex.MultipleCompositeIndexEntity;
import org.neo4j.ogm.session.SessionFactory;

public class CompositeIndexAutoIndexManagerTest
extends BaseAutoIndexManagerTestClass {
    private static final String[] INDEXES = new String[]{"INDEX ON :`EntityWithCompositeIndex`(`name`,`age`)", "INDEX ON :`EntityWithMultipleCompositeIndexes`(`name`,`age`)", "INDEX ON :`EntityWithMultipleCompositeIndexes`(`name`,`email`)"};
    private static final String CONSTRAINT = "CONSTRAINT ON (entity:EntityWithCompositeIndex) ASSERT (entity.name, entity.age) IS NODE KEY";

    public CompositeIndexAutoIndexManagerTest() {
        super(INDEXES, CompositeIndexEntity.class, CompositeIndexChild.class, MultipleCompositeIndexEntity.class);
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
        Assume.assumeTrue((String)"This test uses composite index and node key constraint and can only be run on enterprise edition", (boolean)CompositeIndexAutoIndexManagerTest.isEnterpriseEdition());
        Assume.assumeTrue((String)"This tests uses composite index and can only be run on Neo4j 3.2.0 and later", (boolean)CompositeIndexAutoIndexManagerTest.isVersionOrGreater((String)"3.2.0"));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.executeDrop(CONSTRAINT);
    }

    @Test
    public void testAutoIndexManagerUpdateConstraintChangedToIndex() {
        this.executeCreate(CONSTRAINT);
        this.runAutoIndex("update");
        this.executeForIndexes(indexes -> Assertions.assertThat(indexes.stream().filter(CompositeIndexAutoIndexManagerTest.byLabel("EntityWithCompositeIndex"))).asList().hasSize(1));
        this.executeForConstraints(constraints -> Assertions.assertThat((List)constraints).isEmpty());
    }

    @Test
    public void testMultipleCompositeIndexAnnotations() {
        try {
            this.runAutoIndex("update");
            this.executeForIndexes(indexes -> {
                AbstractListAssert cfr_ignored_0 = (AbstractListAssert)Assertions.assertThat(indexes.stream().filter(CompositeIndexAutoIndexManagerTest.byLabel("EntityWithMultipleCompositeIndexes"))).asList().hasSize(2);
            });
        }
        catch (Throwable throwable) {
            this.executeDrop("INDEX ON :EntityWithMultipleCompositeIndexes(name, age)");
            this.executeDrop("INDEX ON :EntityWithMultipleCompositeIndexes(name, email)");
            throw throwable;
        }
        this.executeDrop("INDEX ON :EntityWithMultipleCompositeIndexes(name, age)");
        this.executeDrop("INDEX ON :EntityWithMultipleCompositeIndexes(name, email)");
    }

    @Test
    public void shouldSupportScanningNonEntityPackages() {
        new SessionFactory(new String[]{CompositeIndexAutoIndexManagerTest.class.getName()});
    }

    private static Predicate<IndexDefinition> byLabel(String label) {
        return indexDefinition -> label.equals(indexDefinition.getLabel().name());
    }
}

