/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.autoindex;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Test;
import org.neo4j.ogm.autoindex.BaseAutoIndexManagerTestClass;
import org.neo4j.ogm.domain.autoindex.SingleIndexEntity;

public class SingleIndexAutoIndexManagerTest
extends BaseAutoIndexManagerTestClass {
    private static final String INDEX = "INDEX ON :`Entity`(`login`)";
    private static final String CONSTRAINT = "CONSTRAINT ON (entity:Entity) ASSERT entity.login IS UNIQUE";

    public SingleIndexAutoIndexManagerTest() {
        super(new String[]{INDEX}, SingleIndexEntity.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.executeDrop(CONSTRAINT);
    }

    @Test
    public void testAutoIndexManagerUpdateConstraintChangedToIndex() throws Exception {
        this.executeCreate(CONSTRAINT);
        this.runAutoIndex("update");
        this.executeForIndexes(indexes -> Assertions.assertThat((List)indexes).hasSize(1));
        this.executeForConstraints(constraints -> Assertions.assertThat((List)constraints).isEmpty());
    }
}

