/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.autoindex;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Test;
import org.neo4j.ogm.autoindex.BaseAutoIndexManagerTestClass;
import org.neo4j.ogm.domain.autoindex.UniqueConstraintEntity;

public class UniqueConstraintAutoIndexManagerTest
extends BaseAutoIndexManagerTestClass {
    private static final String INDEX = "INDEX ON :`Entity`(`login`)";
    private static final String CONSTRAINT = "CONSTRAINT ON (`entity`:`Entity`) ASSERT `entity`.`login` IS UNIQUE";

    public UniqueConstraintAutoIndexManagerTest() {
        super(new String[]{CONSTRAINT}, UniqueConstraintEntity.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.executeDrop(INDEX);
    }

    @Test
    public void testAutoIndexManagerUpdateIndexChangedToConstraint() throws Exception {
        this.executeCreate(INDEX);
        this.runAutoIndex("update");
        this.executeForIndexes(indexes -> Assertions.assertThat((List)indexes).isEmpty());
        this.executeForConstraints(constraints -> Assertions.assertThat((List)constraints).hasSize(1));
    }
}

