/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.assertj.core.api.Assertions;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.drivers.http.driver.HttpDriver;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.FileUtils;

public class DriverServiceTest {
    private static final Path TMP_NEO4J = Paths.get(System.getProperty("java.io.tmpdir"), "neo4jDriverServiceTest.db");
    private static final Path TMP_NEO4J_DB = Paths.get(TMP_NEO4J.toFile().getAbsolutePath() + "/database", new String[0]);

    @BeforeClass
    public static void createEmbeddedStore() {
        try {
            Files.createDirectories(TMP_NEO4J_DB, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @AfterClass
    public static void deleteEmbeddedStore() throws IOException {
        FileUtils.deleteDirectory((Path)TMP_NEO4J);
    }

    @Test
    public void shouldLoadHttpDriver() {
        Configuration driverConfiguration = new Configuration.Builder().uri("http://neo4j:password@localhost:7474").build();
        SessionFactory sf = new SessionFactory(driverConfiguration, new String[]{"org.neo4j.ogm.domain.social.User"});
        Driver driver = sf.getDriver();
        Assertions.assertThat((Object)driver).isNotNull();
        sf.close();
    }

    @Test
    public void shouldLoadEmbeddedDriver() {
        Configuration driverConfiguration = new Configuration.Builder().uri(TMP_NEO4J_DB.toUri().toString()).build();
        SessionFactory sf = new SessionFactory(driverConfiguration, new String[]{"org.neo4j.ogm.domain.social.User"});
        Driver driver = sf.getDriver();
        Assertions.assertThat((Object)driver).isNotNull();
        driver.close();
        sf.close();
    }

    @Test
    @Ignore
    public void shouldDisableCertificateValidationIfIgnoreSSLHandshake() {
        Throwable throwable;
        HttpDriver driver2;
        HttpPost request = new HttpPost("https://neo4j:password@localhost:7473/db/data/transaction/commit");
        request.setEntity((HttpEntity)new StringEntity("{\n  \"statements\" : [ {\n    \"statement\" : \"MATCH (n) RETURN id(n)\"\n  } ]\n}", "UTF-8"));
        Configuration configuration = new Configuration.Builder().uri("https://neo4j:password@localhost:7473").trustStrategy("ACCEPT_UNSIGNED").build();
        SessionFactory sf = new SessionFactory(configuration, new String[]{"org.neo4j.ogm.domain.social.User"});
        try {
            driver2 = (HttpDriver)sf.getDriver();
            throwable = null;
            try {
                driver2.configure(configuration);
                driver2.executeHttpRequest((HttpRequestBase)request);
                Assert.fail((String)"Should have thrown security exception");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (driver2 != null) {
                    if (throwable != null) {
                        try {
                            driver2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        driver2.close();
                    }
                }
            }
        }
        catch (Exception driver2) {
            // empty catch block
        }
        sf.close();
        sf = new SessionFactory(configuration, new String[]{"org.neo4j.ogm.domain.social.User"});
        try {
            driver2 = (HttpDriver)sf.getDriver();
            throwable = null;
            try {
                driver2.configure(configuration);
                driver2.executeHttpRequest((HttpRequestBase)request);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (driver2 != null) {
                    if (throwable != null) {
                        try {
                            driver2.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        driver2.close();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Should NOT have thrown security exception");
        }
        sf.close();
    }
}

