/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.lang.reflect.Field;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.context.LabelPrimaryId;
import org.neo4j.ogm.context.MappedRelationship;
import org.neo4j.ogm.context.MappingContext;
import org.neo4j.ogm.domain.annotations.ids.ValidAnnotations;
import org.neo4j.ogm.domain.policy.Person;
import org.neo4j.ogm.domain.policy.Policy;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.typeconversion.UuidStringConverter;

public class MappingContextTest {
    private static Field PRIMARY_ID_TO_NATIVE_ID_ACCESSOR;
    private MappingContext mappingContext;
    private MetaData metaData;

    @BeforeClass
    public static void setUpPrimaryIdToNativeIdAccessor() {
        try {
            PRIMARY_ID_TO_NATIVE_ID_ACCESSOR = MappingContext.class.getDeclaredField("primaryIdToNativeId");
            PRIMARY_ID_TO_NATIVE_ID_ACCESSOR.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    @Before
    public void setUp() {
        this.metaData = new MetaData(new String[]{"org.neo4j.ogm.domain.policy", "org.neo4j.ogm.context", "org.neo4j.ogm.domain.annotations.ids"});
        this.mappingContext = new MappingContext(this.metaData);
    }

    @Test
    public void testPath() {
        Person jim = new Person("jim");
        jim.setId(1L);
        Policy policy = new Policy("healthcare");
        policy.setId(2L);
        this.mappingContext.addNodeEntity((Object)jim);
        this.mappingContext.addNodeEntity((Object)policy);
        this.mappingContext.addRelationship(new MappedRelationship(jim.getId().longValue(), "INFLUENCES", policy.getId().longValue(), Person.class, Policy.class));
        Assertions.assertThat((Object)this.mappingContext.getNodeEntity(jim.getId())).isEqualTo((Object)jim);
        Assertions.assertThat((Object)this.mappingContext.getNodeEntity(policy.getId())).isEqualTo((Object)policy);
        Assertions.assertThat((boolean)this.mappingContext.containsRelationship(new MappedRelationship(jim.getId().longValue(), "INFLUENCES", policy.getId().longValue(), Person.class, Policy.class))).isTrue();
    }

    @Test
    public void clearOne() {
        Person jim = new Person("jim");
        jim.setId(1L);
        Policy policy = new Policy("healthcare");
        policy.setId(2L);
        this.mappingContext.addNodeEntity((Object)jim);
        this.mappingContext.addNodeEntity((Object)policy);
        this.mappingContext.addRelationship(new MappedRelationship(jim.getId().longValue(), "INFLUENCES", policy.getId().longValue(), Person.class, Policy.class));
        this.mappingContext.removeEntity((Object)jim);
        Assertions.assertThat((Object)this.mappingContext.getNodeEntity(jim.getId())).isEqualTo(null);
        Assertions.assertThat((Object)this.mappingContext.getNodeEntity(policy.getId())).isEqualTo((Object)policy);
        Assertions.assertThat((boolean)this.mappingContext.containsRelationship(new MappedRelationship(jim.getId().longValue(), "INFLUENCES", policy.getId().longValue(), Person.class, Policy.class))).isFalse();
    }

    @Test
    public void clearOneEqualToAnother() {
        Person jim = new Person("jim");
        jim.setId(1L);
        Person another = new Person("jim");
        another.setId(3L);
        Policy policy = new Policy("healthcare");
        policy.setId(2L);
        this.mappingContext.addNodeEntity((Object)jim);
        this.mappingContext.addNodeEntity((Object)another);
        this.mappingContext.addNodeEntity((Object)policy);
        this.mappingContext.addRelationship(new MappedRelationship(jim.getId().longValue(), "INFLUENCES", policy.getId().longValue(), Person.class, Policy.class));
        this.mappingContext.removeEntity((Object)jim);
        Assertions.assertThat((Object)this.mappingContext.getNodeEntity(jim.getId())).isEqualTo(null);
        Assertions.assertThat((Object)this.mappingContext.getNodeEntity(policy.getId())).isEqualTo((Object)policy);
        Assertions.assertThat((Object)this.mappingContext.getNodeEntity(another.getId())).isEqualTo((Object)another);
        Assertions.assertThat((boolean)this.mappingContext.containsRelationship(new MappedRelationship(jim.getId().longValue(), "INFLUENCES", policy.getId().longValue(), Person.class, Policy.class))).isFalse();
    }

    @Test
    public void clearType() {
        Person jim = new Person("jim");
        jim.setId(1L);
        Policy healthcare = new Policy("healthcare");
        healthcare.setId(2L);
        Policy immigration = new Policy("immigration");
        immigration.setId(3L);
        Person rik = new Person("rik");
        rik.setId(4L);
        this.mappingContext.addNodeEntity((Object)jim);
        this.mappingContext.addNodeEntity((Object)rik);
        this.mappingContext.addNodeEntity((Object)healthcare);
        this.mappingContext.addNodeEntity((Object)immigration);
        this.mappingContext.addRelationship(new MappedRelationship(jim.getId().longValue(), "INFLUENCES", healthcare.getId().longValue(), Person.class, Policy.class));
        this.mappingContext.addRelationship(new MappedRelationship(jim.getId().longValue(), "INFLUENCES", immigration.getId().longValue(), Person.class, Policy.class));
        this.mappingContext.addRelationship(new MappedRelationship(jim.getId().longValue(), "WORKS_WITH", rik.getId().longValue(), Person.class, Person.class));
        this.mappingContext.removeType(Policy.class);
        Assertions.assertThat((Iterable)this.mappingContext.getEntities(Policy.class)).isEmpty();
        Assertions.assertThat((Object)this.mappingContext.getNodeEntity(healthcare.getId())).isEqualTo(null);
        Assertions.assertThat((Object)this.mappingContext.getNodeEntity(immigration.getId())).isEqualTo(null);
        Assertions.assertThat((Object)this.mappingContext.getNodeEntity(jim.getId())).isEqualTo((Object)jim);
        Assertions.assertThat((Object)this.mappingContext.getNodeEntity(rik.getId())).isEqualTo((Object)rik);
        Assertions.assertThat((Iterable)this.mappingContext.getRelationships()).hasSize(1);
    }

    @Test
    public void areObjectsReportedAsDirtyCorrectly() {
        Person jim = new Person("jim");
        jim.setId(1L);
        Policy healthcare = new Policy("healthcare");
        healthcare.setId(2L);
        Policy immigration = new Policy("immigration");
        immigration.setId(3L);
        Person rik = new Person("rik");
        rik.setId(4L);
        this.mappingContext.addNodeEntity((Object)jim);
        this.mappingContext.addNodeEntity((Object)rik);
        this.mappingContext.addNodeEntity((Object)healthcare);
        this.mappingContext.addNodeEntity((Object)immigration);
        rik.setName("newRik");
        Assertions.assertThat((boolean)this.mappingContext.isDirty((Object)jim)).isFalse();
        Assertions.assertThat((boolean)this.mappingContext.isDirty((Object)rik)).isTrue();
        Assertions.assertThat((boolean)this.mappingContext.isDirty((Object)healthcare)).isFalse();
        Assertions.assertThat((boolean)this.mappingContext.isDirty((Object)immigration)).isFalse();
    }

    @Test
    public void nativeIdsAreMappedWithoutPrimaryIdConversion() {
        ValidAnnotations.UuidAndGenerationType entity = new ValidAnnotations.UuidAndGenerationType();
        this.mappingContext.nativeId((Object)entity);
        Assertions.assertThat((boolean)this.containsNativeId(this.metaData.classInfo((Object)entity), entity.identifier)).isTrue();
        Assertions.assertThat((boolean)this.containsNativeId(this.metaData.classInfo((Object)entity), new UuidStringConverter().toGraphProperty(entity.identifier))).isFalse();
    }

    @Test
    public void nodeEntitiesAreReplacedWithoutPrimaryIdConversion() {
        ValidAnnotations.UuidAndGenerationType entity = new ValidAnnotations.UuidAndGenerationType();
        this.mappingContext.addNodeEntity((Object)entity);
        Long initialNativeId = this.mappingContext.nativeId((Object)entity);
        this.mappingContext.replaceNodeEntity((Object)entity, Long.valueOf(999L));
        Assertions.assertThat((boolean)this.containsNativeId(this.metaData.classInfo((Object)entity), entity.identifier)).isTrue();
        Assertions.assertThat((boolean)this.containsNativeId(this.metaData.classInfo((Object)entity), new UuidStringConverter().toGraphProperty(entity.identifier))).isFalse();
        Assertions.assertThat((Object)this.mappingContext.getNodeEntity(Long.valueOf(999L))).isSameAs((Object)entity);
        Assertions.assertThat((Object)this.mappingContext.getNodeEntity(initialNativeId)).isNull();
    }

    private boolean containsNativeId(ClassInfo classInfo, Object id) {
        try {
            return ((Map)PRIMARY_ID_TO_NATIVE_ID_ACCESSOR.get(this.mappingContext)).containsKey(new LabelPrimaryId(classInfo, id));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

