/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.annotation.StartNode;
import org.neo4j.ogm.context.MappingContext;
import org.neo4j.ogm.metadata.MetaData;

public class REMappingContextTest {
    private final MetaData metaData = new MetaData(new String[]{"org.neo4j.ogm.context"});
    private final MappingContext context = new MappingContext(this.metaData);
    private Likes likes;

    @Before
    public void setUp() throws Exception {
        this.likes = new Likes();
        this.likes.id = 1L;
        this.likes.uuid = "test-uuid";
    }

    @Test
    public void addedRelationshipEntityIsInContext() throws Exception {
        this.context.addRelationshipEntity((Object)this.likes, Long.valueOf(1L));
        Object entity = this.context.getRelationshipEntity(Long.valueOf(1L));
        Assertions.assertThat((Object)entity).isSameAs((Object)this.likes);
        Object entityById = this.context.getRelationshipEntityById(this.metaData.classInfo((Object)this.likes), (Object)"test-uuid");
        Assertions.assertThat((Object)entityById).isSameAs((Object)this.likes);
    }

    @Test
    public void clearContextClearsPrimaryId() throws Exception {
        this.context.addRelationshipEntity((Object)this.likes, Long.valueOf(1L));
        this.context.clear();
        Object entity = this.context.getRelationshipEntityById(this.metaData.classInfo((Object)this.likes), (Object)"test-uuid");
        Assertions.assertThat((Object)entity).isNull();
    }

    @RelationshipEntity(type="LIKES")
    static class Likes {
        Long id;
        @Id
        String uuid;
        @StartNode
        User from;
        @EndNode
        User to;
        int stars;

        Likes() {
        }
    }

    @NodeEntity
    static class User {
        Long id;

        User() {
        }
    }
}

