/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.context.EntityGraphMapper;
import org.neo4j.ogm.context.EntityMapper;
import org.neo4j.ogm.context.MappedRelationship;
import org.neo4j.ogm.context.MappingContext;
import org.neo4j.ogm.cypher.compiler.Compiler;
import org.neo4j.ogm.domain.filesystem.Document;
import org.neo4j.ogm.domain.filesystem.Folder;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.request.StatementFactory;
import org.neo4j.ogm.session.request.RowStatementFactory;

public class DirectRelationshipsTest {
    private static MetaData mappingMetadata;
    private static MappingContext mappingContext;
    private EntityMapper mapper;

    @BeforeClass
    public static void setUpTestDatabase() {
        mappingMetadata = new MetaData(new String[]{"org.neo4j.ogm.domain.filesystem"});
        mappingContext = new MappingContext(mappingMetadata);
    }

    @Before
    public void setUpMapper() {
        this.mapper = new EntityGraphMapper(mappingMetadata, mappingContext);
    }

    @After
    public void tidyUp() {
        mappingContext.clear();
    }

    @Test
    public void shouldSaveNewFolderDocumentPair() {
        Folder folder = new Folder();
        Document document = new Document();
        folder.getDocuments().add(document);
        document.setFolder(folder);
        Compiler compiler = this.mapper.map((Object)folder).getCompiler();
        compiler.useStatementFactory((StatementFactory)new RowStatementFactory());
        List<String> createNodeStatements = this.cypherStatements(compiler.createNodesStatements());
        Assertions.assertThat(createNodeStatements).hasSize(2);
        Assertions.assertThat((boolean)createNodeStatements.contains("UNWIND {rows} as row CREATE (n:`Folder`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type")).isTrue();
        Assertions.assertThat((boolean)createNodeStatements.contains("UNWIND {rows} as row CREATE (n:`Document`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type")).isTrue();
        List<String> createRelStatements = this.cypherStatements(compiler.createRelationshipsStatements());
        Assertions.assertThat(createRelStatements).hasSize(1);
        Assertions.assertThat((String)createRelStatements.get(0)).isEqualTo((Object)"UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MERGE (startNode)-[rel:`CONTAINS`]->(endNode) RETURN row.relRef as ref, ID(rel) as id, {type} as type");
        compiler = this.mapper.map((Object)document).getCompiler();
        compiler.useStatementFactory((StatementFactory)new RowStatementFactory());
        createNodeStatements = this.cypherStatements(compiler.createNodesStatements());
        Assertions.assertThat(createNodeStatements).hasSize(2);
        Assertions.assertThat((boolean)createNodeStatements.contains("UNWIND {rows} as row CREATE (n:`Folder`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type")).isTrue();
        Assertions.assertThat((boolean)createNodeStatements.contains("UNWIND {rows} as row CREATE (n:`Document`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type")).isTrue();
        createRelStatements = this.cypherStatements(compiler.createRelationshipsStatements());
        Assertions.assertThat(createRelStatements).hasSize(1);
        Assertions.assertThat((String)createRelStatements.get(0)).isEqualTo((Object)"UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MERGE (startNode)-[rel:`CONTAINS`]->(endNode) RETURN row.relRef as ref, ID(rel) as id, {type} as type");
    }

    @Test
    public void shouldSaveNewFolderWithTwoDocuments() {
        Folder folder = new Folder();
        Document doc1 = new Document();
        Document doc2 = new Document();
        folder.getDocuments().add(doc1);
        folder.getDocuments().add(doc2);
        doc1.setFolder(folder);
        doc2.setFolder(folder);
        Compiler compiler = this.mapper.map((Object)folder).getCompiler();
        compiler.useStatementFactory((StatementFactory)new RowStatementFactory());
        List statements = compiler.createNodesStatements();
        List<String> createNodeStatements = this.cypherStatements(statements);
        Assertions.assertThat(createNodeStatements).hasSize(2);
        Assertions.assertThat((boolean)createNodeStatements.contains("UNWIND {rows} as row CREATE (n:`Folder`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type")).isTrue();
        Assertions.assertThat((boolean)createNodeStatements.contains("UNWIND {rows} as row CREATE (n:`Document`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type")).isTrue();
        for (Statement statement : statements) {
            List rows = (List)statement.getParameters().get("rows");
            if (statement.getStatement().contains("Folder")) {
                Assertions.assertThat((List)rows).hasSize(1);
            }
            if (!statement.getStatement().contains("Document")) continue;
            Assertions.assertThat((List)rows).hasSize(2);
        }
        statements = compiler.createRelationshipsStatements();
        List<String> createRelStatements = this.cypherStatements(statements);
        Assertions.assertThat(createRelStatements).hasSize(1);
        Assertions.assertThat((String)createRelStatements.get(0)).isEqualTo((Object)"UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MERGE (startNode)-[rel:`CONTAINS`]->(endNode) RETURN row.relRef as ref, ID(rel) as id, {type} as type");
        List rows = (List)((Statement)statements.get(0)).getParameters().get("rows");
        Assertions.assertThat((List)rows).hasSize(2);
        compiler = this.mapper.map((Object)doc1).getCompiler();
        compiler.useStatementFactory((StatementFactory)new RowStatementFactory());
        statements = compiler.createNodesStatements();
        createNodeStatements = this.cypherStatements(statements);
        Assertions.assertThat(createNodeStatements).hasSize(2);
        Assertions.assertThat((boolean)createNodeStatements.contains("UNWIND {rows} as row CREATE (n:`Folder`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type")).isTrue();
        Assertions.assertThat((boolean)createNodeStatements.contains("UNWIND {rows} as row CREATE (n:`Document`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type")).isTrue();
        for (Statement statement : statements) {
            rows = (List)statement.getParameters().get("rows");
            if (statement.getStatement().contains("Folder")) {
                Assertions.assertThat((List)rows).hasSize(1);
            }
            if (!statement.getStatement().contains("Document")) continue;
            Assertions.assertThat((List)rows).hasSize(2);
        }
        statements = compiler.createRelationshipsStatements();
        createRelStatements = this.cypherStatements(statements);
        Assertions.assertThat(createRelStatements).hasSize(1);
        Assertions.assertThat((String)createRelStatements.get(0)).isEqualTo((Object)"UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MERGE (startNode)-[rel:`CONTAINS`]->(endNode) RETURN row.relRef as ref, ID(rel) as id, {type} as type");
        rows = (List)((Statement)statements.get(0)).getParameters().get("rows");
        Assertions.assertThat((List)rows).hasSize(2);
        compiler = this.mapper.map((Object)doc2).getCompiler();
        compiler.useStatementFactory((StatementFactory)new RowStatementFactory());
        statements = compiler.createNodesStatements();
        createNodeStatements = this.cypherStatements(statements);
        Assertions.assertThat(createNodeStatements).hasSize(2);
        Assertions.assertThat((boolean)createNodeStatements.contains("UNWIND {rows} as row CREATE (n:`Folder`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type")).isTrue();
        Assertions.assertThat((boolean)createNodeStatements.contains("UNWIND {rows} as row CREATE (n:`Document`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type")).isTrue();
        for (Statement statement : statements) {
            rows = (List)statement.getParameters().get("rows");
            if (statement.getStatement().contains("Folder")) {
                Assertions.assertThat((List)rows).hasSize(1);
            }
            if (!statement.getStatement().contains("Document")) continue;
            Assertions.assertThat((List)rows).hasSize(2);
        }
        statements = compiler.createRelationshipsStatements();
        createRelStatements = this.cypherStatements(statements);
        Assertions.assertThat(createRelStatements).hasSize(1);
        Assertions.assertThat((String)createRelStatements.get(0)).isEqualTo((Object)"UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MERGE (startNode)-[rel:`CONTAINS`]->(endNode) RETURN row.relRef as ref, ID(rel) as id, {type} as type");
        rows = (List)((Statement)statements.get(0)).getParameters().get("rows");
        Assertions.assertThat((List)rows).hasSize(2);
    }

    @Test
    public void shouldNotBeAbleToCreateDuplicateRelationship() {
        Folder folder = new Folder();
        Document document = new Document();
        document.setFolder(folder);
        folder.getDocuments().add(document);
        folder.getDocuments().add(document);
        Assertions.assertThat(folder.getDocuments()).hasSize(2);
        Compiler compiler = this.mapper.map((Object)folder).getCompiler();
        compiler.useStatementFactory((StatementFactory)new RowStatementFactory());
        List statements = compiler.createNodesStatements();
        List<String> createNodeStatements = this.cypherStatements(statements);
        Assertions.assertThat(createNodeStatements).hasSize(2);
        Assertions.assertThat((boolean)createNodeStatements.contains("UNWIND {rows} as row CREATE (n:`Folder`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type")).isTrue();
        Assertions.assertThat((boolean)createNodeStatements.contains("UNWIND {rows} as row CREATE (n:`Document`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type")).isTrue();
        for (Statement statement : statements) {
            List rows = (List)statement.getParameters().get("rows");
            Assertions.assertThat((List)rows).hasSize(1);
        }
        statements = compiler.createRelationshipsStatements();
        List<String> createRelStatements = this.cypherStatements(statements);
        Assertions.assertThat(createRelStatements).hasSize(1);
        Assertions.assertThat((String)createRelStatements.get(0)).isEqualTo((Object)"UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MERGE (startNode)-[rel:`CONTAINS`]->(endNode) RETURN row.relRef as ref, ID(rel) as id, {type} as type");
        List rows = (List)((Statement)statements.get(0)).getParameters().get("rows");
        Assertions.assertThat((List)rows).hasSize(1);
        compiler = this.mapper.map((Object)document).getCompiler();
        compiler.useStatementFactory((StatementFactory)new RowStatementFactory());
        statements = compiler.createNodesStatements();
        createNodeStatements = this.cypherStatements(statements);
        Assertions.assertThat(createNodeStatements).hasSize(2);
        Assertions.assertThat((boolean)createNodeStatements.contains("UNWIND {rows} as row CREATE (n:`Folder`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type")).isTrue();
        Assertions.assertThat((boolean)createNodeStatements.contains("UNWIND {rows} as row CREATE (n:`Document`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type")).isTrue();
        for (Statement statement : statements) {
            rows = (List)statement.getParameters().get("rows");
            Assertions.assertThat((List)rows).hasSize(1);
        }
        statements = compiler.createRelationshipsStatements();
        createRelStatements = this.cypherStatements(statements);
        Assertions.assertThat(createRelStatements).hasSize(1);
        Assertions.assertThat((String)createRelStatements.get(0)).isEqualTo((Object)"UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MERGE (startNode)-[rel:`CONTAINS`]->(endNode) RETURN row.relRef as ref, ID(rel) as id, {type} as type");
        rows = (List)((Statement)statements.get(0)).getParameters().get("rows");
        Assertions.assertThat((List)rows).hasSize(1);
    }

    @Test
    public void shouldBeAbleToCreateDifferentRelationshipsToTheSameDocument() {
        Folder folder = new Folder();
        Document document = new Document();
        document.setFolder(folder);
        folder.getDocuments().add(document);
        folder.getArchived().add(document);
        Compiler compiler = this.mapper.map((Object)folder).getCompiler();
        compiler.useStatementFactory((StatementFactory)new RowStatementFactory());
        List statements = compiler.createNodesStatements();
        List<String> createNodeStatements = this.cypherStatements(statements);
        Assertions.assertThat(createNodeStatements).hasSize(2);
        Assertions.assertThat((boolean)createNodeStatements.contains("UNWIND {rows} as row CREATE (n:`Folder`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type")).isTrue();
        Assertions.assertThat((boolean)createNodeStatements.contains("UNWIND {rows} as row CREATE (n:`Document`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type")).isTrue();
        for (Statement statement : statements) {
            List rows = (List)statement.getParameters().get("rows");
            Assertions.assertThat((List)rows).hasSize(1);
        }
        statements = compiler.createRelationshipsStatements();
        List<String> createRelStatements = this.cypherStatements(statements);
        Assertions.assertThat(createRelStatements).hasSize(2);
        Assertions.assertThat((boolean)createRelStatements.contains("UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MERGE (startNode)-[rel:`CONTAINS`]->(endNode) RETURN row.relRef as ref, ID(rel) as id, {type} as type")).isTrue();
        Assertions.assertThat((boolean)createRelStatements.contains("UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MERGE (startNode)-[rel:`ARCHIVED`]->(endNode) RETURN row.relRef as ref, ID(rel) as id, {type} as type")).isTrue();
        boolean archivedType = false;
        boolean containsType = false;
        for (Statement statement : statements) {
            if (statement.getStatement().contains("ARCHIVED")) {
                archivedType = true;
            }
            if (!statement.getStatement().contains("CONTAINS")) continue;
            containsType = true;
        }
        Assertions.assertThat((boolean)archivedType).isTrue();
        Assertions.assertThat((boolean)containsType).isTrue();
        compiler = this.mapper.map((Object)document).getCompiler();
        compiler.useStatementFactory((StatementFactory)new RowStatementFactory());
        statements = compiler.createNodesStatements();
        createNodeStatements = this.cypherStatements(statements);
        Assertions.assertThat(createNodeStatements).hasSize(2);
        Assertions.assertThat((boolean)createNodeStatements.contains("UNWIND {rows} as row CREATE (n:`Folder`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type")).isTrue();
        Assertions.assertThat((boolean)createNodeStatements.contains("UNWIND {rows} as row CREATE (n:`Document`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type")).isTrue();
        statements = compiler.createRelationshipsStatements();
        createRelStatements = this.cypherStatements(statements);
        Assertions.assertThat(createRelStatements).hasSize(2);
        Assertions.assertThat((boolean)createRelStatements.contains("UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MERGE (startNode)-[rel:`CONTAINS`]->(endNode) RETURN row.relRef as ref, ID(rel) as id, {type} as type")).isTrue();
        Assertions.assertThat((boolean)createRelStatements.contains("UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MERGE (startNode)-[rel:`ARCHIVED`]->(endNode) RETURN row.relRef as ref, ID(rel) as id, {type} as type")).isTrue();
        archivedType = false;
        containsType = false;
        for (Statement statement : statements) {
            if (statement.getStatement().contains("ARCHIVED")) {
                archivedType = true;
            }
            if (!statement.getStatement().contains("CONTAINS")) continue;
            containsType = true;
        }
        Assertions.assertThat((boolean)archivedType).isTrue();
        Assertions.assertThat((boolean)containsType).isTrue();
    }

    @Test
    public void shouldBeAbleToRemoveTheOnlyRegisteredRelationship() {
        Folder folder = new Folder();
        Document document = new Document();
        folder.getDocuments().add(document);
        document.setFolder(folder);
        folder.setId(0L);
        document.setId(1L);
        mappingContext.addNodeEntity((Object)folder);
        mappingContext.addNodeEntity((Object)document);
        mappingContext.addRelationship(new MappedRelationship(folder.getId().longValue(), "CONTAINS", document.getId().longValue(), Folder.class, Document.class));
        document.setFolder(null);
        folder.getDocuments().clear();
        Compiler compiler = this.mapper.map((Object)folder).getCompiler();
        compiler.useStatementFactory((StatementFactory)new RowStatementFactory());
        List statements = compiler.deleteRelationshipStatements();
        Assertions.assertThat((List)statements).hasSize(1);
        Assertions.assertThat((String)((Statement)statements.get(0)).getStatement()).isEqualTo((Object)"UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MATCH (startNode)-[rel:`CONTAINS`]->(endNode) DELETE rel");
        mappingContext.addRelationship(new MappedRelationship(folder.getId().longValue(), "CONTAINS", document.getId().longValue(), Folder.class, Document.class));
        compiler = this.mapper.map((Object)document).getCompiler();
        compiler.useStatementFactory((StatementFactory)new RowStatementFactory());
        statements = compiler.deleteRelationshipStatements();
        Assertions.assertThat((List)statements).hasSize(1);
        Assertions.assertThat((String)((Statement)statements.get(0)).getStatement()).isEqualTo((Object)"UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MATCH (startNode)-[rel:`CONTAINS`]->(endNode) DELETE rel");
    }

    @Test
    public void shouldBeAbleToRemoveAnyRegisteredRelationship() {
        Folder folder = new Folder();
        Document doc1 = new Document();
        Document doc2 = new Document();
        folder.getDocuments().add(doc1);
        folder.getDocuments().add(doc2);
        doc1.setFolder(folder);
        doc2.setFolder(folder);
        folder.setId(0L);
        doc1.setId(1L);
        doc2.setId(2L);
        mappingContext.addNodeEntity((Object)folder);
        mappingContext.addNodeEntity((Object)doc1);
        mappingContext.addNodeEntity((Object)doc2);
        mappingContext.addRelationship(new MappedRelationship(folder.getId().longValue(), "CONTAINS", doc1.getId().longValue(), Folder.class, Document.class));
        mappingContext.addRelationship(new MappedRelationship(folder.getId().longValue(), "CONTAINS", doc2.getId().longValue(), Folder.class, Document.class));
        doc2.setFolder(null);
        folder.getDocuments().remove(doc2);
        Assertions.assertThat(folder.getDocuments()).hasSize(1);
        Compiler compiler = this.mapper.map((Object)folder).getCompiler();
        compiler.useStatementFactory((StatementFactory)new RowStatementFactory());
        List statements = compiler.deleteRelationshipStatements();
        Assertions.assertThat((List)statements).hasSize(1);
        Assertions.assertThat((String)((Statement)statements.get(0)).getStatement()).isEqualTo((Object)"UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MATCH (startNode)-[rel:`CONTAINS`]->(endNode) DELETE rel");
        mappingContext.addRelationship(new MappedRelationship(folder.getId().longValue(), "CONTAINS", doc2.getId().longValue(), Folder.class, Document.class));
        compiler = this.mapper.map((Object)doc1).getCompiler();
        compiler.useStatementFactory((StatementFactory)new RowStatementFactory());
        statements = compiler.deleteRelationshipStatements();
        Assertions.assertThat((List)statements).hasSize(1);
        Assertions.assertThat((String)((Statement)statements.get(0)).getStatement()).isEqualTo((Object)"UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MATCH (startNode)-[rel:`CONTAINS`]->(endNode) DELETE rel");
        mappingContext.addRelationship(new MappedRelationship(folder.getId().longValue(), "CONTAINS", doc2.getId().longValue(), Folder.class, Document.class));
        compiler = this.mapper.map((Object)doc2).getCompiler();
        compiler.useStatementFactory((StatementFactory)new RowStatementFactory());
        statements = compiler.deleteRelationshipStatements();
        Assertions.assertThat((List)statements).hasSize(1);
        Assertions.assertThat((String)((Statement)statements.get(0)).getStatement()).isEqualTo((Object)"UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MATCH (startNode)-[rel:`CONTAINS`]->(endNode) DELETE rel");
    }

    @Test
    public void shouldBeAbleToRemoveContainedRelationshipOnly() {
        Folder folder = new Folder();
        Document doc1 = new Document();
        folder.getDocuments().add(doc1);
        folder.getArchived().add(doc1);
        doc1.setFolder(folder);
        folder.setId(0L);
        doc1.setId(1L);
        mappingContext.addNodeEntity((Object)folder);
        mappingContext.addNodeEntity((Object)doc1);
        mappingContext.addRelationship(new MappedRelationship(folder.getId().longValue(), "CONTAINS", doc1.getId().longValue(), Folder.class, Document.class));
        mappingContext.addRelationship(new MappedRelationship(folder.getId().longValue(), "ARCHIVED", doc1.getId().longValue(), Folder.class, Document.class));
        folder.getDocuments().remove(doc1);
        doc1.setFolder(null);
        Assertions.assertThat(folder.getDocuments()).isEmpty();
        Assertions.assertThat(folder.getArchived()).hasSize(1);
        Compiler compiler = this.mapper.map((Object)folder).getCompiler();
        compiler.useStatementFactory((StatementFactory)new RowStatementFactory());
        List statements = compiler.deleteRelationshipStatements();
        Assertions.assertThat((List)statements).hasSize(1);
        Assertions.assertThat((String)((Statement)statements.get(0)).getStatement()).isEqualTo((Object)"UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MATCH (startNode)-[rel:`CONTAINS`]->(endNode) DELETE rel");
        this.mapper = new EntityGraphMapper(mappingMetadata, mappingContext);
        compiler = this.mapper.map((Object)doc1).getCompiler();
        compiler.useStatementFactory((StatementFactory)new RowStatementFactory());
        statements = compiler.deleteRelationshipStatements();
        Assertions.assertThat((List)statements).isEmpty();
    }

    private List<String> cypherStatements(List<Statement> statements) {
        ArrayList<String> cypher = new ArrayList<String>(statements.size());
        for (Statement statement : statements) {
            cypher.add(statement.getStatement());
        }
        return cypher;
    }
}

