/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher;

import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.function.ContainsAnyComparison;
import org.neo4j.ogm.cypher.function.DistanceComparison;
import org.neo4j.ogm.cypher.function.DistanceFromPoint;
import org.neo4j.ogm.cypher.function.FilterFunction;
import org.neo4j.ogm.cypher.function.PropertyComparison;

public class FilterTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void toCypher() {
        Filter filter = new Filter("moons", ComparisonOperator.LESS_THAN, (Object)23);
        filter.setBooleanOperator(BooleanOperator.AND);
        Assertions.assertThat((String)filter.toCypher("n", true)).isEqualTo((Object)"WHERE n.`moons` < { `moons_0` } ");
    }

    @Test
    public void toCypher_function() {
        DistanceComparison function = new DistanceComparison(new DistanceFromPoint(Double.valueOf(37.4), Double.valueOf(112.1), Double.valueOf(1000.0)));
        Filter filter = new Filter(function, ComparisonOperator.LESS_THAN);
        filter.setBooleanOperator(BooleanOperator.AND);
        filter.setNegated(true);
        Assertions.assertThat((String)filter.toCypher("n", true)).isEqualTo((Object)"WHERE NOT(distance(point({latitude: n.latitude, longitude: n.longitude}),point({latitude:{lat}, longitude:{lon}})) < {distance} ) ");
    }

    @Test
    public void inCollectionFilterTest() {
        ContainsAnyComparison filterFunction = new ContainsAnyComparison((Object)"test");
        Filter filter = new Filter("property", (FilterFunction)filterFunction);
        Assertions.assertThat((String)filter.toCypher("n", true)).isEqualTo((Object)"WHERE ANY(collectionFields IN {`property_0`} WHERE collectionFields in n.`property`) ");
        Assertions.assertThat(filter.parameters().get("property_0")).isEqualTo((Object)"test");
    }

    @Test
    public void joinFiltersWithAndMethod() {
        Filter filter1 = new Filter("property1", ComparisonOperator.EQUALS, (Object)"value1");
        Filter filter2 = new Filter("property2", ComparisonOperator.EQUALS, (Object)"value2");
        Filters andFilter = filter1.and(filter2);
        Assertions.assertThat((Comparable)filter2.getBooleanOperator()).isEqualTo((Object)BooleanOperator.AND);
        Iterator iterator = andFilter.iterator();
        Assertions.assertThat(iterator.next()).isEqualTo((Object)filter1);
        Assertions.assertThat(iterator.next()).isEqualTo((Object)filter2);
    }

    @Test
    public void joinFiltersWithOrMethod() {
        Filter filter1 = new Filter("property1", ComparisonOperator.EQUALS, (Object)"value1");
        Filter filter2 = new Filter("property2", ComparisonOperator.EQUALS, (Object)"value2");
        Filters andFilter = filter1.or(filter2);
        Assertions.assertThat((Comparable)filter2.getBooleanOperator()).isEqualTo((Object)BooleanOperator.OR);
        Iterator iterator = andFilter.iterator();
        Assertions.assertThat(iterator.next()).isEqualTo((Object)filter1);
        Assertions.assertThat(iterator.next()).isEqualTo((Object)filter2);
    }

    @Test
    public void isNullComparisionShouldWork() {
        Filter filter = new Filter("thing", ComparisonOperator.IS_NULL);
        filter.setBooleanOperator(BooleanOperator.AND);
        Assertions.assertThat((String)filter.toCypher("n", true)).isEqualTo((Object)"WHERE n.`thing` IS NULL ");
    }

    @Test
    public void isExistsComparisionShouldWork() {
        Filter filter = new Filter("thing", ComparisonOperator.EXISTS);
        filter.setBooleanOperator(BooleanOperator.AND);
        Assertions.assertThat((String)filter.toCypher("n", true)).isEqualTo((Object)"WHERE EXISTS(n.`thing`) ");
    }

    @Test
    public void isTrueComparisionShouldWork() {
        Filter filter = new Filter("thing", ComparisonOperator.IS_TRUE);
        filter.setBooleanOperator(BooleanOperator.AND);
        Assertions.assertThat((String)filter.toCypher("n", true)).isEqualTo((Object)"WHERE n.`thing` = true ");
    }

    @Test
    public void equalComparisionShouldWork() {
        String value = "someOtherThing";
        Filter filter = new Filter("thing", ComparisonOperator.EQUALS, (Object)"someOtherThing");
        filter.setFunction((FilterFunction)new PropertyComparison((Object)"someOtherThing"));
        Assertions.assertThat((String)filter.toCypher("n", true)).isEqualTo((Object)"WHERE n.`thing` = { `thing_0` } ");
        filter = new Filter("thing", ComparisonOperator.EQUALS, (Object)"someOtherThing");
        filter.ignoreCase();
        Assertions.assertThat((String)filter.toCypher("n", true)).isEqualTo((Object)"WHERE toLower(n.`thing`) = toLower({ `thing_0` }) ");
    }

    @Test
    public void ignoreCaseShouldNotBeApplicableToComparisonOtherThanEquals() {
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("ignoreCase is only supported for EQUALS comparison");
        Filter filter = new Filter("thing", ComparisonOperator.IS_NULL);
        filter.setBooleanOperator(BooleanOperator.AND);
        Assertions.assertThat((String)filter.toCypher("n", true)).isEqualTo((Object)"WHERE n.`thing` IS NULL ");
        filter.ignoreCase();
        Assertions.assertThat((String)filter.toCypher("n", true)).isEqualTo((Object)"WHERE n.`thing` IS NULL ");
    }
}

