/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.compiler;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.domain.gh576.DataItem;
import org.neo4j.ogm.domain.gh576.FormulaItem;
import org.neo4j.ogm.domain.gh576.Variable;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.neo4j.ogm.testutil.TestUtils;

@RunWith(value=Parameterized.class)
public class CypherContextTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private static String createTestDataStatement;
    private Session session;

    @Parameterized.Parameters
    public static List<Integer> data() {
        return IntStream.range(0, 10).boxed().collect(Collectors.toList());
    }

    @BeforeClass
    public static void initSesssionFactory() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.gh576"});
    }

    public CypherContextTest(Integer iterations) {
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
        this.session.clear();
        this.session.query(createTestDataStatement, Collections.emptyMap());
    }

    @Test
    public void shouldDeregisterRelationshipEntities() {
        Filter filter = new Filter("nodeId", ComparisonOperator.EQUALS, (Object)"m1");
        Collection dataItems = this.session.loadAll(DataItem.class, filter);
        Assertions.assertThat((Iterable)dataItems).hasSize(1);
        FormulaItem formulaItem = (FormulaItem)dataItems.iterator().next();
        Assertions.assertThat(formulaItem.getVariables()).hasSize(3);
        Predicate<Variable> isVariableAWithDataItemM2 = v -> v.getVariable().equals("A") && v.getDataItem().getNodeId().equals("m2");
        formulaItem.getVariables().removeIf(isVariableAWithDataItemM2);
        Assertions.assertThat(formulaItem.getVariables()).hasSize(2);
        this.session.save((Object)formulaItem);
        dataItems = this.session.loadAll(DataItem.class, filter);
        Assertions.assertThat((Iterable)dataItems).hasSize(1);
        formulaItem = (FormulaItem)dataItems.iterator().next();
        Assertions.assertThat(formulaItem.getVariables()).hasSize(2);
    }

    @After
    public void tearDown() {
        this.session.purgeDatabase();
    }

    static {
        createTestDataStatement = TestUtils.readCQLFile((String)"org/neo4j/ogm/cql/nodes.cql").toString();
    }
}

