/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.domain.annotations.ids;

import java.util.UUID;
import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.GeneratedValue;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.annotation.StartNode;
import org.neo4j.ogm.annotation.typeconversion.Convert;
import org.neo4j.ogm.id.UuidStrategy;
import org.neo4j.ogm.metadata.IdGenerationTest;
import org.neo4j.ogm.typeconversion.UuidStringConverter;

public class ValidAnnotations {

    @RelationshipEntity(type="REL")
    public static class RelationshipEntityWithId {
        Long id;
        @Id
        @GeneratedValue(strategy=UuidStrategy.class)
        public String uuid;
        @StartNode
        public IdAndGenerationType startNode;
        @EndNode
        public IdAndGenerationType endNode;
        public int value;

        public RelationshipEntityWithId() {
        }

        public RelationshipEntityWithId(IdAndGenerationType startNode, IdAndGenerationType endNode, int value) {
            this.startNode = startNode;
            this.endNode = endNode;
            this.value = value;
        }
    }

    public static class WithCustomInstanceIdStrategy {
        public Long id;
        @Id
        @GeneratedValue(strategy=IdGenerationTest.CustomInstanceIdStrategy.class)
        public String identifier;
    }

    public static class WithCustomIdStrategy {
        public Long id;
        @Id
        @GeneratedValue(strategy=IdGenerationTest.CustomIdStrategy.class)
        public String identifier;
    }

    public static class BasicChild
    extends Basic {
    }

    public static class UuidAndGenerationType {
        @Id
        @GeneratedValue(strategy=UuidStrategy.class)
        @Convert(value=UuidStringConverter.class)
        public UUID identifier;
    }

    public static class UuidIdAndGenerationTypeWithoutIdAttribute {
        @Id
        @GeneratedValue(strategy=UuidStrategy.class)
        @Convert(value=UuidStringConverter.class)
        public UUID identifier;
    }

    public static class UuidIdAndGenerationType {
        public Long id;
        @Id
        @GeneratedValue(strategy=UuidStrategy.class)
        @Convert(value=UuidStringConverter.class)
        public UUID identifier;
    }

    public static class IdAndGenerationType {
        public Long id;
        @Id
        @GeneratedValue(strategy=UuidStrategy.class)
        public String identifier;
    }

    public static class Basic {
        public Long id;
        @Id
        public String identifier;
    }

    public static class InternalIdWithAnnotation {
        @Id
        @GeneratedValue
        public Long identifier;
    }

    public static class InternalId {
        public Long id;
    }

    public static class WithoutId {
        @Id
        public String identifier;
    }
}

