/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.domain.cineasts.annotated;

import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.neo4j.ogm.annotation.Index;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.annotation.typeconversion.Convert;
import org.neo4j.ogm.domain.cineasts.annotated.Nomination;
import org.neo4j.ogm.domain.cineasts.annotated.Rating;
import org.neo4j.ogm.domain.cineasts.annotated.Role;
import org.neo4j.ogm.domain.cineasts.annotated.URLConverter;
import org.neo4j.ogm.typeconversion.UuidStringConverter;

@NodeEntity
public class Movie {
    Long id;
    @Convert(value=UuidStringConverter.class)
    @Index(unique=true, primary=true)
    private UUID uuid;
    @Index
    String title;
    int year;
    @Relationship(type="ACTS_IN", direction="INCOMING")
    Set<Role> roles = new HashSet<Role>();
    @Relationship(type="RATED", direction="INCOMING")
    Set<Rating> ratings;
    Set<Nomination> nominations;
    @Convert(value=URLConverter.class)
    URL imdbUrl;

    public Movie() {
    }

    public Movie(String title, int year) {
        this.uuid = UUID.randomUUID();
        this.title = title;
        this.year = year;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public Set<Rating> getRatings() {
        return this.ratings;
    }

    public void setRatings(Set<Rating> ratings) {
        this.ratings = ratings;
    }

    public Set<Nomination> getNominations() {
        return this.nominations;
    }

    public void setNominations(Set<Nomination> nominations) {
        this.nominations = nominations;
    }

    public URL getImdbUrl() {
        return this.imdbUrl;
    }

    public void setImdbUrl(URL imdbUrl) {
        this.imdbUrl = imdbUrl;
    }

    public String toString() {
        return "Movie:" + this.title;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Movie movie = (Movie)o;
        if (this.title == null || movie.getTitle() == null) {
            return false;
        }
        return this.title.equals(movie.title);
    }

    public int hashCode() {
        return this.title != null ? this.title.hashCode() : 0;
    }

    public UUID getUuid() {
        return this.uuid;
    }
}

