/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.domain.drink;

import java.util.HashSet;
import java.util.Set;
import org.neo4j.ogm.annotation.GeneratedValue;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.domain.drink.Ingredient;
import org.neo4j.ogm.domain.drink.Manufacturer;
import org.neo4j.ogm.id.UuidStrategy;

@NodeEntity
public class Beverage {
    @Id
    @GeneratedValue(strategy=UuidStrategy.class)
    private String uuid;
    private String name;
    @Relationship(type="CONTAINS")
    private Set<Ingredient> ingredients;
    @Relationship(type="MAKES", direction="INCOMING")
    private Manufacturer manufacturer;

    public Beverage() {
    }

    public Beverage(String name) {
        this.name = name;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public void addIngredient(Ingredient ingredient) {
        if (this.ingredients == null) {
            this.ingredients = new HashSet<Ingredient>();
        }
        this.ingredients.add(ingredient);
        ingredient.addBeverage(this);
    }

    public Manufacturer getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(Manufacturer manufacturer) {
        this.manufacturer = manufacturer;
    }

    public String toString() {
        return "Beverage{uuid='" + this.uuid + '\'' + ", name='" + this.name + '\'' + '}';
    }
}

