/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.domain.drink;

import java.util.HashSet;
import java.util.Set;
import org.neo4j.ogm.annotation.GeneratedValue;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.Labels;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.domain.drink.Beverage;
import org.neo4j.ogm.domain.drink.Owns;
import org.neo4j.ogm.id.UuidStrategy;

@NodeEntity
public class Manufacturer {
    @Id
    @GeneratedValue(strategy=UuidStrategy.class)
    private String uuid;
    private String name;
    @Relationship(type="MAKES")
    private Set<Beverage> beverages;
    @Relationship(type="OWNS")
    private Set<Owns> acquisitions;
    @Labels
    private Set<String> labels;

    public Manufacturer() {
    }

    public Manufacturer(String name) {
        this.name = name;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<Beverage> getBeverages() {
        return this.beverages;
    }

    public void addBeverage(Beverage beverage) {
        if (this.beverages == null) {
            this.beverages = new HashSet<Beverage>();
        }
        this.beverages.add(beverage);
        beverage.setManufacturer(this);
    }

    public Set<Owns> getAcquisitions() {
        return this.acquisitions;
    }

    public void acquired(int year, Manufacturer manufacturer) {
        if (this.acquisitions == null) {
            this.acquisitions = new HashSet<Owns>();
        }
        this.acquisitions.add(new Owns(this, manufacturer, year));
    }

    public Set<String> getLabels() {
        return this.labels;
    }

    public void setLabels(Set<String> labels) {
        this.labels = labels;
    }

    public void addLabel(String label) {
        if (this.labels == null) {
            this.labels = new HashSet<String>();
        }
        this.labels.add(label);
    }
}

