/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.domain.knowledge;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.domain.knowledge.Language;
import org.neo4j.ogm.domain.knowledge.Person;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.neo4j.ogm.transaction.Transaction;

public class KnowledgeTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.knowledge"});
    }

    @Before
    public void init() {
        this.session = sessionFactory.openSession();
    }

    @Test
    public void shouldBeAbleToRollbackObjectWithDifferentKnowledges() {
        Person john = new Person("John");
        Person mary = new Person("Mary");
        Language java = new Language("Java");
        Language scala = new Language("Scala");
        john.knows(mary);
        john.knows(java);
        john.knows(scala);
        try (Transaction tx = this.session.beginTransaction();){
            this.session.save((Object)john);
            tx.rollback();
        }
    }
}

