/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.domain.tree;

import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.neo4j.ogm.annotation.Relationship;

public class Entity
implements Comparable {
    private Long id;
    private String name;
    @Relationship(type="REL", direction="OUTGOING")
    private Entity parent;
    @Relationship(type="REL", direction="INCOMING")
    private SortedSet<Entity> children = new TreeSet<Entity>();

    public Entity() {
    }

    public Entity(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public Set<Entity> getChildren() {
        return this.children;
    }

    public void setChildren(SortedSet<Entity> children) {
        this.children = children;
    }

    public Entity getParent() {
        return this.parent;
    }

    public Entity setParent(Entity parent) {
        parent.children.add(this);
        this.parent = parent;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public int compareTo(Object o) {
        Entity that = (Entity)o;
        if (this.name != null) {
            if (that.name != null) {
                return this.name.compareTo(that.name);
            }
            return 1;
        }
        return -1;
    }
}

