/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.ogm.context.WriteProtectionTarget;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.domain.social.Immortal;
import org.neo4j.ogm.domain.social.Person;
import org.neo4j.ogm.domain.social.User;
import org.neo4j.ogm.exception.CypherException;
import org.neo4j.ogm.exception.TransactionException;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.session.Utils;
import org.neo4j.ogm.session.WriteProtectionStrategy;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.neo4j.ogm.transaction.Transaction;

public class BasicDriverTest
extends MultiDriverTestClass {
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.social"});
    }

    @Before
    public void init() {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void shouldSaveObject() {
        User user = new User("Bilbo Baggins");
        Assertions.assertThat((Long)user.getId()).isNull();
        this.session.save((Object)user);
        Assertions.assertThat((Long)user.getId()).isNotNull();
    }

    @Test
    public void shouldSaveMultipleObjects() throws Exception {
        User bilbo = new User("Bilbo Baggins");
        User frodo = new User("Frodo Beutlin");
        bilbo.befriend(frodo);
        Iterable iterable = Stream.of(bilbo, frodo)::iterator;
        Assertions.assertThat(iterable).isNotInstanceOf(Collection.class);
        this.session.save(iterable);
        this.session.clear();
        Collection users = this.session.loadAll(User.class);
        ((IterableAssert)Assertions.assertThat((Iterable)users).hasSize(2)).extracting(User::getName).containsExactlyInAnyOrder((Object[])new String[]{"Bilbo Baggins", "Frodo Beutlin"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSaveMultipleObjectsWithWriteProtection() throws Exception {
        User bilbo = new User("Bilbo Baggins");
        this.session.save((Object)bilbo);
        this.session.clear();
        try {
            ((Neo4jSession)this.session).addWriteProtection(WriteProtectionTarget.PROPERTIES, object -> object instanceof User && bilbo.getId().equals(((User)object).getId()));
            User frodo = new User("Frodo Beutlin");
            bilbo.befriend(frodo);
            bilbo.setName("The wrong name");
            Iterable iterable = Stream.of(bilbo, frodo)::iterator;
            Assertions.assertThat(iterable).isNotInstanceOf(Collection.class);
            this.session.save(iterable);
            this.session.clear();
            Collection users = this.session.loadAll(User.class);
            ((IterableAssert)Assertions.assertThat((Iterable)users).hasSize(2)).extracting(User::getName).containsExactlyInAnyOrder((Object[])new String[]{"Bilbo Baggins", "Frodo Beutlin"});
        }
        finally {
            ((Neo4jSession)this.session).removeWriteProtection(WriteProtectionTarget.PROPERTIES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSaveMultipleObjectsWithWriteProtectionFromRoot() throws Exception {
        User avon = new User("Avon Barksdale");
        this.session.save((Object)avon);
        User stringer = new User("Stringer Bell");
        this.session.save((Object)stringer);
        this.session.clear();
        try {
            ((Neo4jSession)this.session).addWriteProtection(WriteProtectionTarget.PROPERTIES, object -> object instanceof User && !avon.getId().equals(((User)object).getId()));
            stringer.setName("Marlo");
            avon.befriend(stringer);
            this.session.save((Object)avon);
            this.session.clear();
            Collection users = this.session.loadAll(User.class);
            ((IterableAssert)Assertions.assertThat((Iterable)users).hasSize(2)).extracting(User::getName).containsExactlyInAnyOrder((Object[])new String[]{"Avon Barksdale", "Stringer Bell"});
        }
        finally {
            ((Neo4jSession)this.session).removeWriteProtection(WriteProtectionTarget.PROPERTIES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void customWriteProtectionStrategyShouldBeApplied() {
        Predicate<Object> alwaysWriteProtect = o -> true;
        Predicate<Object> protectAvon = o -> ((User)o).getName().startsWith("Avon");
        WriteProtectionStrategy customStrategy = () -> (target, clazz) -> {
            if (clazz == Immortal.class) {
                return alwaysWriteProtect;
            }
            if (clazz == User.class) {
                return protectAvon;
            }
            return null;
        };
        User avon = new User("Avon Barksdale");
        this.session.save((Object)avon);
        User stringer = new User("Stringer Bell");
        this.session.save((Object)stringer);
        Immortal connor = new Immortal("Connor", "MacLeod");
        this.session.save((Object)connor);
        Person person = new Person("A person");
        this.session.save((Object)person);
        this.session.clear();
        try {
            ((Neo4jSession)this.session).setWriteProtectionStrategy(customStrategy);
            stringer.setName("Avon Something");
            avon.befriend(stringer);
            this.session.save((Object)avon);
            connor.setFirstName("Duncan");
            this.session.save((Object)connor);
            person.setName("John Reese");
            this.session.save((Object)person);
            this.session.clear();
            Collection users = this.session.loadAll(User.class);
            ((IterableAssert)Assertions.assertThat((Iterable)users).hasSize(2)).extracting(User::getName).containsExactlyInAnyOrder((Object[])new String[]{"Avon Barksdale", "Stringer Bell"});
            Collection immortals = this.session.loadAll(Immortal.class);
            ((IterableAssert)Assertions.assertThat((Iterable)immortals).hasSize(1)).extracting(Immortal::getFirstName).containsExactlyInAnyOrder((Object[])new String[]{"Connor"});
            Collection personsOfInterest = this.session.loadAll(Person.class);
            ((IterableAssert)Assertions.assertThat((Iterable)personsOfInterest).hasSize(1)).extracting(Person::getName).containsExactlyInAnyOrder((Object[])new String[]{"John Reese"});
        }
        finally {
            ((Neo4jSession)this.session).setWriteProtectionStrategy(null);
        }
    }

    @Test
    public void shouldLoadByType() {
        this.session.save((Object)new User());
        this.session.clear();
        Assertions.assertThat((Iterable)this.session.loadAll(User.class)).hasSize(1);
    }

    @Test
    public void shouldLoadOne() {
        User user = new User();
        this.session.save((Object)user);
        this.session.clear();
        User userByType = (User)this.session.load(User.class, (Serializable)user.getId());
        Assertions.assertThat((Object)userByType).isNotNull();
    }

    @Test
    public void shouldLoadByProperty() {
        User user = new User("Bilbo Baggins");
        this.session.save((Object)user);
        this.session.clear();
        User userByProperty = (User)this.session.loadAll(User.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"Bilbo Baggins")).iterator().next();
        Assertions.assertThat((Object)userByProperty).isNotNull();
    }

    @Test
    public void shouldLoadByInstances() {
        User bilbo = new User("Bilbo Baggins");
        User frodo = new User("Frodo Baggins");
        ArrayList<User> users = new ArrayList<User>();
        users.add(bilbo);
        users.add(frodo);
        this.session.save(users);
        this.session.clear();
        Collection userByInstances = this.session.loadAll(users);
        Assertions.assertThat((Iterable)userByInstances).isNotNull();
        Assertions.assertThat((Iterable)userByInstances).hasSize(2);
    }

    @Test
    public void shouldLoadByIds() {
        User bilbo = new User("Bilbo Baggins");
        User frodo = new User("Frodo Baggins");
        this.session.save((Object)bilbo);
        this.session.save((Object)frodo);
        this.session.clear();
        Collection userByInstances = this.session.loadAll(User.class, Arrays.asList(frodo.getId(), bilbo.getId()));
        Assertions.assertThat((Iterable)userByInstances).isNotNull();
        Assertions.assertThat((Iterable)userByInstances).hasSize(2);
    }

    @Test
    public void shouldQueryForObject() {
        this.session.save((Object)new User("Bilbo Baggins"));
        this.session.clear();
        User bilbo = (User)this.session.queryForObject(User.class, "MATCH(u:User) RETURN u", Utils.map((Object[])new Object[]{"name", "Bilbo Baggins"}));
        Assertions.assertThat((Object)bilbo).isNotNull();
    }

    @Test
    public void shouldQueryForDomainObjects() {
        this.session.save((Object)new User("Bilbo Baggins"));
        this.session.save((Object)new User("Frodo Baggins"));
        this.session.clear();
        Collection users = (Collection)this.session.query(User.class, "MATCH(u:User) WHERE u.name =~ '.*Baggins' RETURN u", Utils.map((Object[])new Object[0]));
        Assertions.assertThat((Iterable)users).isNotNull();
        Assertions.assertThat((Iterable)users).hasSize(2);
    }

    @Test
    public void shouldQueryForScalarValues() {
        this.session.save((Object)new User("Bilbo Baggins"));
        this.session.save((Object)new User("Frodo Baggins"));
        this.session.clear();
        Collection userNames = (Collection)this.session.query(String.class, "MATCH(u:User) WHERE u.name =~ '.*Baggins' RETURN u.name", Utils.map((Object[])new Object[0]));
        Assertions.assertThat((Iterable)userNames).isNotNull();
        Assertions.assertThat((Iterable)userNames).hasSize(2);
    }

    @Test
    public void shouldObtainEmptyQueryResultsWithStatistics() {
        this.session.save((Object)new User("Bilbo Baggins"));
        this.session.save((Object)new User("Frodo Baggins"));
        this.session.clear();
        Result result = this.session.query("MATCH (u:User) WHERE u.name =~ '.*Baggins' SET u.species = 'Hobbit'", Utils.map((Object[])new Object[0]));
        Assertions.assertThat((int)result.queryStatistics().getPropertiesSet()).isEqualTo(2);
        Assertions.assertThat((boolean)((Iterable)result.queryResults()).iterator().hasNext()).isFalse();
    }

    @Test
    public void shouldObtainQueryResultsWithStatistics() {
        this.session.save((Object)new User("Bilbo Baggins"));
        this.session.save((Object)new User("Frodo Baggins"));
        this.session.clear();
        Result result = this.session.query("MATCH (u:User) WHERE u.name =~ '.*Baggins' SET u.species = 'Hobbit' RETURN u.name", Utils.map((Object[])new Object[0]));
        Assertions.assertThat((int)result.queryStatistics().getPropertiesSet()).isEqualTo(2);
        Assertions.assertThat((boolean)((Iterable)result.queryResults()).iterator().hasNext()).isTrue();
    }

    @Test
    public void shouldFindExplicitlyCommittedEntity() {
        Transaction tx = this.session.beginTransaction();
        this.session.save((Object)new User());
        tx.commit();
        this.session.clear();
        Assertions.assertThat((Iterable)this.session.loadAll(User.class)).hasSize(1);
    }

    @Test
    public void shouldNotFindExplicitlyRolledBackEntity() {
        Transaction tx = this.session.beginTransaction();
        this.session.save((Object)new User());
        tx.rollback();
        this.session.clear();
        Assertions.assertThat((Iterable)this.session.loadAll(User.class)).isEmpty();
    }

    @Test
    public void shouldFailExtendedCommitRollbackCommit() {
        try {
            this.doExtendedCommitRollbackCommit();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (TransactionException txe) {
            Assertions.assertThat((Iterable)this.session.loadAll(User.class)).isEmpty();
        }
    }

    @Test
    public void shouldFailExtendedRollbackCommitCommit() {
        try {
            this.doExtendedRollbackCommitCommit();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (TransactionException txe) {
            Assertions.assertThat((Iterable)this.session.loadAll(User.class)).isEmpty();
        }
    }

    @Test
    @Ignore
    public void shouldFailExtendedRollbackRollbackCommit() {
        try {
            this.doExtendedRollbackRollbackCommit();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (TransactionException txe) {
            Assertions.assertThat((Iterable)this.session.loadAll(User.class)).isEmpty();
        }
    }

    @Test
    public void shouldSucceedExtendedCommitCommitCommit() {
        this.doExtendedCommitCommitCommit();
        Assertions.assertThat((Iterable)this.session.loadAll(User.class)).hasSize(2);
    }

    @Test
    public void shouldSucceedExtendedCommitRollbackRollback() {
        this.doExtendedCommitRollbackRollback();
        Assertions.assertThat((Iterable)this.session.loadAll(User.class)).isEmpty();
    }

    @Test
    public void shouldSucceedExtendedRollbackCommitRollback() {
        try {
            this.doExtendedRollbackCommitRollback();
            Assertions.fail((String)"Should have caught exception");
        }
        catch (TransactionException txe) {
            Assertions.assertThat((Iterable)this.session.loadAll(User.class)).isEmpty();
        }
    }

    @Test
    public void shouldSucceedExtendedRollbackRollbackRollback() {
        this.doExtendedRollbackRollbackRollback();
        Assertions.assertThat((Iterable)this.session.loadAll(User.class)).isEmpty();
    }

    @Test
    public void shouldSucceedExtendedCommitCommitRollback() {
        this.doExtendedCommitCommitRollback();
        Assertions.assertThat((Iterable)this.session.loadAll(User.class)).isEmpty();
    }

    @Test
    public void shouldWrapUnderlyingException() {
        this.session.save((Object)new User("Bilbo Baggins"));
        try {
            this.session.query(User.class, "MATCH(u:User) WHERE u.name ~ '.*Baggins' RETURN u", Utils.map((Object[])new Object[0]));
            Assertions.fail((String)"Expected a CypherException but got none");
        }
        catch (CypherException ce) {
            Assertions.assertThat((boolean)ce.getCode().contains("Neo.ClientError.Statement")).isTrue();
        }
    }

    private void doExtendedCommitRollbackCommit() throws TransactionException {
        try (Transaction tx = this.session.beginTransaction();){
            this.m2();
            this.m3();
            tx.commit();
        }
    }

    private void doExtendedRollbackCommitCommit() throws TransactionException {
        try (Transaction tx = this.session.beginTransaction();){
            this.m3();
            this.m2();
            tx.commit();
        }
    }

    private void doExtendedCommitCommitCommit() {
        try (Transaction tx = this.session.beginTransaction();){
            this.m2();
            this.m2();
            tx.commit();
        }
    }

    private void doExtendedRollbackRollbackCommit() throws TransactionException {
        try (Transaction tx = this.session.beginTransaction();){
            this.m3();
            this.m3();
            tx.commit();
        }
    }

    private void doExtendedCommitRollbackRollback() {
        try (Transaction tx = this.session.beginTransaction();){
            this.m2();
            this.m3();
            tx.rollback();
        }
    }

    private void doExtendedRollbackCommitRollback() {
        try (Transaction tx = this.session.beginTransaction();){
            this.m3();
            this.m2();
            tx.rollback();
        }
    }

    private void doExtendedCommitCommitRollback() {
        try (Transaction tx = this.session.beginTransaction();){
            this.m2();
            this.m2();
            tx.rollback();
        }
    }

    private void doExtendedRollbackRollbackRollback() {
        try (Transaction tx = this.session.beginTransaction();){
            this.m3();
            this.m3();
            tx.rollback();
        }
    }

    private void m2() {
        try (Transaction tx = this.session.beginTransaction();){
            this.session.save((Object)new User());
            tx.commit();
        }
    }

    private void m3() {
        try (Transaction tx = this.session.beginTransaction();){
            this.session.save((Object)new User());
            tx.rollback();
        }
    }
}

