/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers;

import org.assertj.core.api.Assertions;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.harness.ServerControls;
import org.neo4j.harness.TestServerBuilders;
import org.neo4j.ogm.domain.cypher_exception_test.ConstraintedNode;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.exception.CypherException;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;

public abstract class CypherExceptionTestBase<T extends Driver> {
    private static final String CONSTRAINT_VIOLATED_MESSAGE_PATTERN = "Cypher execution failed with code 'Neo\\.ClientError\\.Schema\\.ConstraintValidationFailed': Node(?: |\\(?)\\d\\)? already exists with label `?CONSTRAINTED_NODE`? and property (?:`|\")name(?:`|\") ?= ?(?:'test'|\\[test\\])\\.";
    protected static final String DOMAIN_PACKAGE = "org.neo4j.ogm.domain.cypher_exception_test";
    protected static ServerControls serverControls;

    @BeforeClass
    public static void startServer() {
        serverControls = TestServerBuilders.newInProcessBuilder().withFixture(database -> {
            database.execute("MATCH (n:CONSTRAINTED_NODE) DETACH DELETE n");
            database.execute("CREATE CONSTRAINT ON (n:CONSTRAINTED_NODE) ASSERT n.name IS UNIQUE");
            database.execute("CREATE (n:CONSTRAINTED_NODE {name: 'test'})");
            return null;
        }).newServer();
    }

    protected abstract SessionFactory getSessionFactory();

    @Test
    public void constraintViolationExceptionShouldBeConsistent() {
        Session session = this.getSessionFactory().openSession();
        Assertions.assertThatExceptionOfType(CypherException.class).isThrownBy(() -> {
            ConstraintedNode node = new ConstraintedNode("test");
            session.save((Object)node);
        }).withMessageMatching(CONSTRAINT_VIOLATED_MESSAGE_PATTERN);
    }

    @AfterClass
    public static void stopServer() {
        serverControls.close();
    }
}

