/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.config.ClasspathConfigurationSource;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.config.ConfigurationSource;
import org.neo4j.ogm.config.Credentials;
import org.neo4j.ogm.config.UsernamePasswordCredentials;

public class DriverConfigurationTest {
    @Test
    public void shouldLoadHttpDriverConfigFromPropertiesFile() {
        Configuration driverConfig = new Configuration.Builder((ConfigurationSource)new ClasspathConfigurationSource("http.driver.properties")).build();
        Assertions.assertThat((String)driverConfig.getURI()).isEqualTo((Object)"http://localhost:7474");
    }

    @Test
    public void shouldLoadEmbeddedDriverConfigFromPropertiesFile() {
        Configuration driverConfig = new Configuration.Builder((ConfigurationSource)new ClasspathConfigurationSource("embedded.driver.properties")).build();
        Assertions.assertThat((String)driverConfig.getURI()).isEqualTo((Object)"file:///var/tmp/neo4j.db");
    }

    @Test
    public void shouldLoadBoltDriverConfigFromPropertiesFile() {
        Configuration driverConfig = new Configuration.Builder((ConfigurationSource)new ClasspathConfigurationSource("bolt.driver.properties")).build();
        Assertions.assertThat((String)driverConfig.getURI()).isEqualTo((Object)"bolt://localhost");
        Assertions.assertThat((int)driverConfig.getConnectionPoolSize()).isEqualTo(150);
        Assertions.assertThat((String)driverConfig.getEncryptionLevel()).isEqualTo((Object)"NONE");
        Assertions.assertThat((String)driverConfig.getTrustStrategy()).isEqualTo((Object)"TRUST_ON_FIRST_USE");
        Assertions.assertThat((String)driverConfig.getTrustCertFile()).isEqualTo((Object)"/tmp/cert");
    }

    @Test
    public void shouldSetUsernameAndPasswordCredentialsForBoltProtocol() {
        String username = "neo4j";
        String password = "password";
        Configuration dbConfig = new Configuration.Builder().uri("bolt://" + username + ":" + password + "@localhost").build();
        Credentials credentials = dbConfig.getCredentials();
        UsernamePasswordCredentials basic = (UsernamePasswordCredentials)credentials;
        Assertions.assertThat((Object)basic).isNotNull();
        Assertions.assertThat((String)basic.getUsername()).isEqualTo((Object)username);
        Assertions.assertThat((String)basic.getPassword()).isEqualTo((Object)password);
    }

    @Test
    public void shouldGetNeo4jHaPropertiesFileFromDriverConfiguration() {
        Configuration config = new Configuration.Builder((ConfigurationSource)new ClasspathConfigurationSource("embedded.ha.driver.properties")).build();
        Assertions.assertThat((String)config.getNeo4jConfLocation()).isEqualTo((Object)"neo4j-ha.properties");
    }
}

