/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers;

import org.junit.Test;
import org.neo4j.ogm.config.ClasspathConfigurationSource;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.config.ConfigurationSource;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;

public class DriverExceptionTest {
    @Test(expected=Exception.class)
    public void shouldThrowExceptionWhenHttpDriverCannotConnect() {
        Configuration configuration = new Configuration.Builder((ConfigurationSource)new ClasspathConfigurationSource("ogm-http-invalid.properties")).build();
        SessionFactory sessionFactory = new SessionFactory(configuration, new String[]{"org.neo4j.ogm.domain.social"});
        Session session = sessionFactory.openSession();
        session.purgeDatabase();
    }

    @Test(expected=Exception.class)
    public void shouldThrowExceptionWhenEmbeddedDriverCannotConnect() {
        Configuration configuration = new Configuration.Builder((ConfigurationSource)new ClasspathConfigurationSource("ogm-embedded-invalid.properties")).build();
        SessionFactory sessionFactory = new SessionFactory(configuration, new String[]{"org.neo4j.ogm.domain.social"});
        Session session = sessionFactory.openSession();
        session.purgeDatabase();
    }

    @Test(expected=Exception.class)
    public void shouldThrowExceptionWhenBoltDriverCannotConnect() {
        Configuration configuration = new Configuration.Builder((ConfigurationSource)new ClasspathConfigurationSource("ogm-bolt-invalid.properties")).build();
        SessionFactory sessionFactory = new SessionFactory(configuration, new String[]{"org.neo4j.ogm.domain.social"});
        Session session = sessionFactory.openSession();
        session.purgeDatabase();
    }
}

