/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.model.QueryStatistics;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryStatisticsTest
extends MultiDriverTestClass {
    private static final Logger logger = LoggerFactory.getLogger(QueryStatisticsTest.class);
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.social"});
    }

    @Before
    public void init() {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void statisticsContainsUpdates() {
        Result result = this.session.query("CREATE (n:Node)", Collections.emptyMap());
        QueryStatistics statistics = result.queryStatistics();
        Assertions.assertThat((boolean)statistics.containsUpdates()).isTrue();
    }

    @Test
    public void statisticsNodesCreated() {
        Result result = this.session.query("CREATE (n:Node)", Collections.emptyMap());
        QueryStatistics statistics = result.queryStatistics();
        Assertions.assertThat((int)statistics.getNodesCreated()).isEqualTo(1);
    }

    @Test
    public void statisticsNodesDeleted() {
        this.session.query("CREATE (n:Node)", Collections.emptyMap());
        Result result = this.session.query("MATCH (n:Node) DELETE n", Collections.emptyMap());
        QueryStatistics statistics = result.queryStatistics();
        Assertions.assertThat((int)statistics.getNodesDeleted()).isEqualTo(1);
    }

    @Test
    public void statisticsPropertiesSet() {
        Result result = this.session.query("CREATE (n:Node {name:'Frantisek'})-[r:REL {weight:1.0}]->(n2:Node)", Collections.emptyMap());
        QueryStatistics statistics = result.queryStatistics();
        Assertions.assertThat((int)statistics.getPropertiesSet()).isEqualTo(2);
    }

    @Test
    public void statisticsRelationshipsCreated() {
        Result result = this.session.query("CREATE (n:Node)-[r:REL]->(n2:Node)", Collections.emptyMap());
        QueryStatistics statistics = result.queryStatistics();
        Assertions.assertThat((int)statistics.getRelationshipsCreated()).isEqualTo(1);
    }

    @Test
    public void statisticsRelationshipsDeleted() {
        this.session.query("CREATE (n:Node)-[r:REL]->(n2:Node)", Collections.emptyMap());
        Result result = this.session.query("MATCH (n:Node)-[r:REL]->(n2:Node) DELETE r", Collections.emptyMap());
        QueryStatistics statistics = result.queryStatistics();
        Assertions.assertThat((int)statistics.getRelationshipsDeleted()).isEqualTo(1);
    }

    @Test
    public void statisticsLabelsAdded() {
        Result result = this.session.query("CREATE (n:Node)", Collections.emptyMap());
        QueryStatistics statistics = result.queryStatistics();
        Assertions.assertThat((int)statistics.getLabelsAdded()).isEqualTo(1);
    }

    @Test
    public void statisticsLabelsRemoved() {
        this.session.query("CREATE (n:Node)", Collections.emptyMap());
        Result result = this.session.query("MATCH (n:Node) REMOVE n:Node", Collections.emptyMap());
        QueryStatistics statistics = result.queryStatistics();
        Assertions.assertThat((int)statistics.getLabelsRemoved()).isEqualTo(1);
    }

    @Test
    public void statisticsIndexesAdded() {
        try {
            Result result = this.session.query("CREATE INDEX ON :Label(property)", Collections.emptyMap());
            QueryStatistics statistics = result.queryStatistics();
            Assertions.assertThat((int)statistics.getIndexesAdded()).isEqualTo(1);
        }
        catch (Exception e) {
            Assertions.fail((String)"Error during test", (Throwable)e);
        }
        finally {
            try {
                this.session.query("DROP INDEX ON :Label(property)", Collections.emptyMap());
            }
            catch (Exception e1) {
                logger.warn("Error during index/constraint cleanup", (Throwable)e1);
            }
        }
    }

    @Test
    public void statisticsIndexesRemoved() {
        try {
            this.session.query("CREATE INDEX ON :Label(property)", Collections.emptyMap());
            Result result = this.session.query("DROP INDEX ON :Label(property)", Collections.emptyMap());
            QueryStatistics statistics = result.queryStatistics();
            Assertions.assertThat((int)statistics.getIndexesRemoved()).isEqualTo(1);
        }
        catch (Exception e) {
            Assertions.fail((String)"Error during test", (Throwable)e);
        }
        finally {
            try {
                this.session.query("DROP INDEX ON :Label(property)", Collections.emptyMap());
            }
            catch (Exception e1) {
                logger.warn("Error during index/constraint cleanup", (Throwable)e1);
            }
        }
    }

    @Test
    public void statisticsConstraintsAdded() {
        try {
            Result result = this.session.query("CREATE CONSTRAINT ON (n:Node) ASSERT n.property IS UNIQUE", Collections.emptyMap());
            QueryStatistics statistics = result.queryStatistics();
            Assertions.assertThat((int)statistics.getConstraintsAdded()).isEqualTo(1);
        }
        catch (Exception e) {
            Assertions.fail((String)"Error during test", (Throwable)e);
        }
        finally {
            try {
                this.session.query("DROP CONSTRAINT ON (n:Node) ASSERT n.property IS UNIQUE", Collections.emptyMap());
            }
            catch (Exception e1) {
                logger.warn("Error during index/constraint cleanup", (Throwable)e1);
            }
        }
    }

    @Test
    public void statisticsConstraintsRemoved() {
        try {
            this.session.query("CREATE CONSTRAINT ON (n:Node) ASSERT n.property IS UNIQUE", Collections.emptyMap());
            Result result = this.session.query("DROP CONSTRAINT ON (n:Node) ASSERT n.property IS UNIQUE", Collections.emptyMap());
            QueryStatistics statistics = result.queryStatistics();
            Assertions.assertThat((int)statistics.getConstraintsRemoved()).isEqualTo(1);
        }
        catch (Exception e) {
            Assertions.fail((String)"Error during test", (Throwable)e);
        }
        finally {
            try {
                this.session.query("DROP CONSTRAINT ON (n:Node) ASSERT n.property IS UNIQUE", Collections.emptyMap());
            }
            catch (Exception e1) {
                logger.debug("Error during index/constraint cleanup", (Throwable)e1);
            }
        }
    }
}

