/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.bolt;

import java.time.LocalDateTime;
import java.util.HashMap;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assume;
import org.junit.Test;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.types.TypeSystem;
import org.neo4j.ogm.driver.AbstractConfigurableDriver;
import org.neo4j.ogm.driver.ParameterConversionMode;
import org.neo4j.ogm.drivers.bolt.driver.BoltDriver;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.testutil.SingleDriverTestClass;

public class JavaBasedParameterConversionTest
extends SingleDriverTestClass {
    @Test
    public void shouldUseNativeTypesWhenNonNativeTypesOnlyIsActive() {
        Assume.assumeTrue((boolean)JavaBasedParameterConversionTest.driverSupportsLocalDate());
        Assume.assumeTrue((boolean)this.databaseSupportJava8TimeTypes());
        HashMap<String, ParameterConversionMode> customConfiguration = new HashMap<String, ParameterConversionMode>();
        customConfiguration.put(ParameterConversionMode.CONFIG_PARAMETER_CONVERSION_MODE, ParameterConversionMode.CONVERT_NON_NATIVE_ONLY);
        try (Driver driver = this.getDriver();){
            BoltDriver boltOgmDriver = new BoltDriver(driver, () -> customConfiguration);
            this.doWithSessionFactoryOf((AbstractConfigurableDriver)boltOgmDriver, new Class[]{JavaBasedParameterConversionTest.class}, sessionFactory -> {
                Session session = sessionFactory.openSession();
                LocalDateTime originalDateTime = LocalDateTime.of(2018, 10, 11, 15, 24);
                HashMap<String, LocalDateTime> parameters = new HashMap<String, LocalDateTime>();
                parameters.put("createdAt", originalDateTime);
                session.query("CREATE (n:Test {createdAt: $createdAt})", parameters);
                Record record = driver.session().run("MATCH (n:Test) RETURN n.createdAt as createdAt").single();
                Object createdAt = record.get("createdAt").asObject();
                ((AbstractObjectAssert)Assertions.assertThat((Object)createdAt).isInstanceOf(LocalDateTime.class)).isEqualTo((Object)originalDateTime);
            });
        }
    }

    private static boolean driverSupportsLocalDate() {
        Class<TypeSystem> t = TypeSystem.class;
        try {
            return t.getDeclaredMethod("LOCAL_DATE_TIME", new Class[0]) != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }
}

