/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.bolt;

import org.assertj.core.api.Assertions;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;
import org.neo4j.ogm.config.ClasspathConfigurationSource;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.config.ConfigurationSource;
import org.neo4j.ogm.session.SessionFactory;

public class MultipleURIsBoltDriverTest {
    @Test
    public void throwCorrectExceptionOnUnavailableCluster() throws Exception {
        Configuration configuration = new Configuration.Builder().uri("bolt+routing://localhost:1022").uris(new String[]{"bolt+routing://localhost:1023"}).verifyConnection(Boolean.valueOf(true)).build();
        try {
            new SessionFactory(configuration, new String[]{"org.neo4j.ogm.domain.social"});
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            Assertions.assertThat((Throwable)cause).isInstanceOf(ServiceUnavailableException.class);
            Assertions.assertThat((Throwable)cause).hasMessage("Failed to discover an available server");
        }
    }

    @Test
    @Ignore(value="this needs local causal cluster running")
    public void connectToCCUsingConfiguration() throws Exception {
        Configuration configuration = new Configuration.Builder().uri("bolt+routing://localhost:1023").uris(new String[]{"bolt+routing://localhost:7688", "bolt+routing://localhost:7687", "bolt+routing://localhost:7689"}).verifyConnection(Boolean.valueOf(true)).build();
        new SessionFactory(configuration, new String[]{"org.neo4j.ogm.domain.social"});
    }

    @Test
    @Ignore(value="this needs local causal cluster running")
    public void connectToCCUsingProperties() throws Exception {
        Configuration configuration = new Configuration.Builder((ConfigurationSource)new ClasspathConfigurationSource("ogm-bolt-uris.properties")).build();
        new SessionFactory(configuration, new String[]{"org.neo4j.ogm.domain.social"});
    }
}

