/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.embedded;

import java.time.LocalDateTime;
import java.util.HashMap;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assume;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.ogm.driver.AbstractConfigurableDriver;
import org.neo4j.ogm.driver.ParameterConversionMode;
import org.neo4j.ogm.drivers.embedded.driver.EmbeddedDriver;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.testutil.SingleDriverTestClass;

public class EmbeddedBasedParameterConversionTest
extends SingleDriverTestClass {
    @Test
    public void shouldUseNativeTypesWhenNonNativeTypesOnlyIsActive() {
        Assume.assumeTrue((boolean)this.databaseSupportJava8TimeTypes());
        HashMap<String, ParameterConversionMode> customConfiguration = new HashMap<String, ParameterConversionMode>();
        customConfiguration.put(ParameterConversionMode.CONFIG_PARAMETER_CONVERSION_MODE, ParameterConversionMode.CONVERT_NON_NATIVE_ONLY);
        GraphDatabaseService graphDatabaseService = this.getGraphDatabaseService();
        EmbeddedDriver embeddedOgmDriver = new EmbeddedDriver(graphDatabaseService, () -> customConfiguration);
        this.doWithSessionFactoryOf((AbstractConfigurableDriver)embeddedOgmDriver, new Class[]{EmbeddedBasedParameterConversionTest.class}, sessionFactory -> {
            Session session = sessionFactory.openSession();
            LocalDateTime originalDateTime = LocalDateTime.of(2018, 10, 11, 15, 24);
            HashMap<String, LocalDateTime> parameters = new HashMap<String, LocalDateTime>();
            parameters.put("createdAt", originalDateTime);
            session.query("CREATE (n:Test {createdAt: $createdAt})", parameters);
            Object createdAt = graphDatabaseService.execute("MATCH (n:Test) RETURN n.createdAt AS createdAt").next().get("createdAt");
            ((AbstractObjectAssert)Assertions.assertThat(createdAt).isInstanceOf(LocalDateTime.class)).isEqualTo((Object)originalDateTime);
        });
    }
}

