/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.embedded;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.assertj.core.api.Assertions;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.drivers.embedded.driver.EmbeddedDriver;
import org.neo4j.test.TestGraphDatabaseFactory;

public class EmbeddedDatabaseTest {
    @BeforeClass
    public static void setUp() {
        Assume.assumeTrue((boolean)"ogm-embedded.properties".equals(System.getProperty("ogm.properties")));
    }

    @Test
    public void shouldCreateImpermanentInstanceWhenNoURI() {
        Configuration configuration = new Configuration.Builder().build();
        try (EmbeddedDriver driver = new EmbeddedDriver();){
            driver.configure(configuration);
            Assertions.assertThat((String)configuration.getURI()).isNull();
            Assertions.assertThat((Object)driver.getGraphDatabaseService()).isNotNull();
        }
    }

    @Test
    public void shouldWriteAndRead() {
        try (EmbeddedDriver driver = new EmbeddedDriver();){
            driver.configure(new Configuration.Builder().build());
            GraphDatabaseService databaseService = driver.getGraphDatabaseService();
            try (Transaction tx = databaseService.beginTx();){
                databaseService.execute("CREATE (n: Node {name: 'node'})");
                Result r = databaseService.execute("MATCH (n) RETURN n");
                Assertions.assertThat((boolean)r.hasNext()).isTrue();
                tx.success();
            }
        }
    }

    @Test
    public void shouldWriteAndReadFromProvidedDatabase() throws Exception {
        GraphDatabaseService impermanentDatabase = new TestGraphDatabaseFactory().newImpermanentDatabase();
        try (EmbeddedDriver driver = new EmbeddedDriver(impermanentDatabase);){
            GraphDatabaseService databaseService = driver.getGraphDatabaseService();
            try (Transaction tx = databaseService.beginTx();){
                databaseService.execute("CREATE (n: Node {name: 'node'})");
                Result r = databaseService.execute("MATCH (n) RETURN n");
                Assertions.assertThat((boolean)r.hasNext()).isTrue();
                tx.success();
            }
        }
    }

    @Test
    public void shouldBeAbleToHaveMultipleInstances() {
        Configuration configuration = new Configuration.Builder().build();
        try (EmbeddedDriver driver1 = new EmbeddedDriver();
             EmbeddedDriver driver2 = new EmbeddedDriver();){
            driver1.configure(configuration);
            driver2.configure(configuration);
            Assertions.assertThat((Object)driver1.getGraphDatabaseService()).isNotNull();
            Assertions.assertThat((Object)driver2.getGraphDatabaseService()).isNotNull();
            Assertions.assertThat((driver1.getGraphDatabaseService() == driver2.getGraphDatabaseService() ? 1 : 0) != 0).isFalse();
            Assertions.assertThat((boolean)driver1.getGraphDatabaseService().toString().equals(driver2.getGraphDatabaseService().toString())).isFalse();
        }
    }

    @Test
    public void impermanentInstancesShouldNotShareTheSameDatabase() {
        Configuration configuration = new Configuration.Builder().build();
        try (EmbeddedDriver driver1 = new EmbeddedDriver();
             EmbeddedDriver driver2 = new EmbeddedDriver();){
            driver1.configure(configuration);
            driver2.configure(configuration);
            GraphDatabaseService db1 = driver1.getGraphDatabaseService();
            GraphDatabaseService db2 = driver2.getGraphDatabaseService();
            try (Transaction tx = db1.beginTx();){
                db1.execute("CREATE (n: Node {name: 'node'})");
                tx.success();
            }
            var9_14 = null;
            try (Transaction tx1 = db1.beginTx();
                 Transaction tx2 = db2.beginTx();){
                Result r1 = db1.execute("MATCH (n) RETURN n");
                Result r2 = db2.execute("MATCH (n) RETURN n");
                Assertions.assertThat((boolean)r1.hasNext()).isTrue();
                Assertions.assertThat((boolean)r2.hasNext()).isFalse();
                tx1.success();
                tx2.success();
            }
            catch (Throwable throwable) {
                var9_14 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"Should not have thrown exception");
        }
    }

    @Test
    public void shouldCreateDirectoryIfMissing() throws IOException {
        String EMBEDDED_DIR = "/var/tmp/ogmEmbeddedDir";
        Path path = Paths.get("/var/tmp/ogmEmbeddedDir", new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            this.deleteDirectory(path);
        }
        Configuration configuration = new Configuration.Builder().uri("file:///var/tmp/ogmEmbeddedDir").build();
        try (EmbeddedDriver driver = new EmbeddedDriver();){
            driver.configure(configuration);
            Assertions.assertThat((String)configuration.getURI()).isEqualTo((Object)"file:///var/tmp/ogmEmbeddedDir");
            Assertions.assertThat((Object)driver.getGraphDatabaseService()).isNotNull();
            Assertions.assertThat((boolean)Files.exists(path, new LinkOption[0])).isTrue();
        }
        this.deleteDirectory(path);
    }

    private void deleteDirectory(Path path) {
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

