/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.embedded.driver;

import org.assertj.core.api.Assertions;
import org.junit.Assume;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.security.WriteOperationsNotAllowedException;
import org.neo4j.ogm.config.ClasspathConfigurationSource;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.config.ConfigurationSource;
import org.neo4j.ogm.drivers.embedded.driver.EmbeddedDriver;
import org.neo4j.ogm.support.ClassUtils;

public class EmbeddedDriverTest {
    public static final String NAME_OF_HA_DATABASE_CLASS = "HighlyAvailableGraphDatabase";

    @Test
    public void shouldHandleCustomConfFiles() {
        try (EmbeddedDriver driver = new EmbeddedDriver();){
            driver.configure(new Configuration.Builder().neo4jConfLocation("classpath:custom-neo4j.conf").build());
            GraphDatabaseService databaseService = driver.getGraphDatabaseService();
            EmbeddedDriverTest.assertReadOnly(databaseService);
        }
    }

    @Test
    public void shouldHandleCustomConfFilesFromOgmProperties() {
        try (EmbeddedDriver driver = new EmbeddedDriver();){
            driver.configure(new Configuration.Builder((ConfigurationSource)new ClasspathConfigurationSource("ogm-pointing-to-custom-conf.properties")).build());
            GraphDatabaseService databaseService = driver.getGraphDatabaseService();
            EmbeddedDriverTest.assertReadOnly(databaseService);
        }
    }

    private static void assertReadOnly(GraphDatabaseService databaseService) {
        Result r = databaseService.execute("MATCH (n) RETURN n");
        Assertions.assertThat((boolean)r.hasNext()).isFalse();
        try (Transaction tx = databaseService.beginTx();){
            Assertions.assertThatExceptionOfType(WriteOperationsNotAllowedException.class).isThrownBy(() -> databaseService.execute("CREATE (n: Node {name: 'node'})"));
            tx.failure();
        }
    }

    @Test
    public void shouldLoadHaBasedOnHaPropertiesFile() {
        Assume.assumeTrue((boolean)EmbeddedDriverTest.canRunHATests());
        try (EmbeddedDriver driver = new EmbeddedDriver();){
            driver.configure(new Configuration.Builder((ConfigurationSource)new ClasspathConfigurationSource("embedded.ha.driver.properties")).build());
            GraphDatabaseService databaseService = driver.getGraphDatabaseService();
            Assertions.assertThat((String)databaseService.getClass().getSimpleName()).isEqualTo((Object)NAME_OF_HA_DATABASE_CLASS);
        }
    }

    @Test
    public void shouldLoadHaBasedOnNeo4ConfFile() {
        Assume.assumeTrue((boolean)EmbeddedDriverTest.canRunHATests());
        try (EmbeddedDriver driver = new EmbeddedDriver();){
            driver.configure(new Configuration.Builder().neo4jConfLocation("classpath:custom-neo4j-ha.conf").build());
            GraphDatabaseService databaseService = driver.getGraphDatabaseService();
            Assertions.assertThat((String)databaseService.getClass().getSimpleName()).isEqualTo((Object)NAME_OF_HA_DATABASE_CLASS);
        }
    }

    static boolean canRunHATests() {
        try {
            Class.forName("org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory", false, ClassUtils.getDefaultClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

