/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.embedded.extension;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.Configuration;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.harness.ServerControls;
import org.neo4j.ogm.domain.simple.User;
import org.neo4j.ogm.drivers.embedded.extension.OgmPluginInitializer;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.TestServer;
import org.neo4j.server.plugins.Injectable;
import org.neo4j.test.server.HTTP;

public class OgmPluginInitializerTest {
    private static final String TEST_PATH = "/testOgmExtension/";

    @Before
    public void setUp() throws Exception {
        TestOgmPluginInitializer.shouldInitialize = true;
    }

    @After
    public void after() throws Exception {
        TestOgmPluginInitializer.shouldInitialize = false;
    }

    @Test
    public void testOgmPluginExtension() throws Exception {
        try (ServerControls controls = TestServer.newInProcessBuilder().withConfig(GraphDatabaseSettings.auth_enabled, "false").withExtension(TEST_PATH, TestOgmExtension.class).newServer();){
            URI testURI = controls.httpURI().resolve(TEST_PATH);
            HTTP.Response saveResponse = HTTP.POST((String)testURI.toString());
            Assertions.assertThat((int)saveResponse.status()).isEqualTo(200);
            HTTP.Response loadResponse = HTTP.GET((String)testURI.toString());
            Assertions.assertThat((String)loadResponse.rawContent()).isEqualTo((Object)"[{\"id\":0,\"name\":\"new user\"}]");
        }
    }

    @Test
    public void ogmExtensionShouldUseProvidedDatabase() throws Exception {
        try (ServerControls controls = TestServer.newInProcessBuilder().withConfig(GraphDatabaseSettings.auth_enabled, "false").withExtension(TEST_PATH, TestOgmExtension.class).newServer();){
            URI testURI = controls.httpURI().resolve(TEST_PATH);
            GraphDatabaseService service = controls.graph();
            try (Transaction tx = service.beginTx();){
                service.execute("CREATE (u:User {name:'new user'})");
                tx.success();
            }
            HTTP.Response loadResponse = HTTP.GET((String)testURI.toString());
            Assertions.assertThat((String)loadResponse.rawContent()).isEqualTo((Object)"[{\"id\":0,\"name\":\"new user\"}]");
        }
    }

    public static class TestOgmPluginInitializer
    extends OgmPluginInitializer {
        public static boolean shouldInitialize = false;

        public TestOgmPluginInitializer() {
            super(User.class.getPackage().getName());
        }

        public Collection<Injectable<?>> start(GraphDatabaseService graphDatabaseService, Configuration config) {
            if (shouldInitialize) {
                return super.start(graphDatabaseService, config);
            }
            return Collections.emptySet();
        }
    }

    @Path(value="")
    public static class TestOgmExtension {
        @Context
        private SessionFactory sessionFactory;
        private ObjectMapper objectMapper = new ObjectMapper();

        @POST
        public Response save() {
            Session session = this.sessionFactory.openSession();
            User user = new User("new user");
            session.save((Object)user);
            return Response.ok().build();
        }

        @GET
        public Response load() throws JsonProcessingException {
            Session session = this.sessionFactory.openSession();
            Collection users = session.loadAll(User.class);
            return Response.ok().entity((Object)this.objectMapper.writeValueAsString((Object)users)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
    }
}

