/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.http.response;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.ogm.drivers.http.response.AbstractHttpResponse;
import org.neo4j.ogm.model.Edge;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.model.Node;
import org.neo4j.ogm.model.Property;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.result.ResultGraphModel;

public class JsonGraphResponseTest {
    private static CloseableHttpResponse response = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
    private static HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);

    @Before
    public void setUpMocks() {
        Mockito.when((Object)response.getEntity()).thenReturn((Object)entity);
    }

    @Test
    public void shouldParseColumnsInGraphResponseCorrectly() throws IOException {
        Mockito.when((Object)entity.getContent()).thenReturn((Object)this.graphResultsAndNoErrors());
        try (TestGraphHttpResponse rsp = new TestGraphHttpResponse();){
            Assertions.assertThat((int)rsp.columns().length).isEqualTo(1);
            Assertions.assertThat((String)rsp.columns()[0]).isEqualTo((Object)"_0");
        }
    }

    @Test
    public void shouldParseColumnsInGraphResponseWithNoColumnsCorrectly() throws IOException {
        Mockito.when((Object)entity.getContent()).thenReturn((Object)this.noGraphResultsAndNoErrors());
        try (TestGraphHttpResponse rsp = new TestGraphHttpResponse();){
            Assertions.assertThat((int)rsp.columns().length).isEqualTo(1);
            Assertions.assertThat((String)rsp.columns()[0]).isEqualTo((Object)"_0");
        }
    }

    @Test
    public void shouldParseDataInLoadByIdsGraphResponseCorrectly() throws IOException {
        Mockito.when((Object)entity.getContent()).thenReturn((Object)this.loadByIdsGraphResults());
        try (TestGraphHttpResponse rsp = new TestGraphHttpResponse();){
            GraphModel graphModel = (GraphModel)rsp.next();
            Assertions.assertThat((Object)graphModel).isNotNull();
            Set nodes = graphModel.getNodes();
            Assertions.assertThat((Iterable)nodes).hasSize(1);
            Assertions.assertThat((Object)((Property)((Node)nodes.iterator().next()).getPropertyList().get(0)).getValue()).isEqualTo((Object)"adam");
            Assertions.assertThat((Iterable)graphModel.getRelationships()).isEmpty();
            graphModel = (GraphModel)rsp.next();
            Assertions.assertThat((Object)graphModel).isNotNull();
            nodes = graphModel.getNodes();
            Assertions.assertThat((Iterable)nodes).hasSize(2);
            Iterator nodeIterator = nodes.iterator();
            nodeIterator.next();
            Assertions.assertThat((Object)((Property)((Node)nodeIterator.next()).getPropertyList().get(0)).getValue()).isEqualTo((Object)"GraphAware");
            Assertions.assertThat((Iterable)graphModel.getRelationships()).hasSize(1);
            Assertions.assertThat((String)((Edge)graphModel.getRelationships().iterator().next()).getType()).isEqualTo((Object)"EMPLOYED_BY");
            for (int i = 0; i < 4; ++i) {
                Assertions.assertThat((Object)rsp.next()).isNotNull();
            }
            Assertions.assertThat((Object)rsp.next()).isNull();
        }
    }

    private InputStream graphResultsAndNoErrors() {
        String s = "{\n  \"results\": [\n    {\n      \"columns\": [\n        \"_0\"\n      ],\n      \"data\": [\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"381\",\n                \"labels\": [\n                  \"School\"\n                ],\n                \"properties\": {}\n              }\n            ],\n            \"relationships\": []\n          }\n        }\n      ]\n    }\n  ],\n  \"errors\": []\n}";
        return new ByteArrayInputStream("{\n  \"results\": [\n    {\n      \"columns\": [\n        \"_0\"\n      ],\n      \"data\": [\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"381\",\n                \"labels\": [\n                  \"School\"\n                ],\n                \"properties\": {}\n              }\n            ],\n            \"relationships\": []\n          }\n        }\n      ]\n    }\n  ],\n  \"errors\": []\n}".getBytes(StandardCharsets.UTF_8));
    }

    private InputStream noGraphResultsAndNoErrors() {
        String s = "{\n  \"results\": [\n    {\n      \"columns\": [\n        \"_0\"\n      ],\n      \"data\": []\n    }\n  ],\n  \"errors\": []\n}";
        return new ByteArrayInputStream("{\n  \"results\": [\n    {\n      \"columns\": [\n        \"_0\"\n      ],\n      \"data\": []\n    }\n  ],\n  \"errors\": []\n}".getBytes(StandardCharsets.UTF_8));
    }

    private InputStream loadByIdsGraphResults() {
        String s = "{\n  \"results\": [\n    {\n      \"columns\": [\n        \"p\"\n      ],\n      \"data\": [\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"343\",\n                \"labels\": [\n                  \"User\"\n                ],\n                \"properties\": {\n                  \"firstName\": \"adam\"\n                }\n              }\n            ],\n            \"relationships\": []\n          }\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"343\",\n                \"labels\": [\n                  \"User\"\n                ],\n                \"properties\": {\n                  \"firstName\": \"adam\"\n                }\n              },\n              {\n                \"id\": \"26\",\n                \"labels\": [\n                  \"Customer\"\n                ],\n                \"properties\": {\n                  \"name\": \"GraphAware\"\n                }\n              }\n            ],\n            \"relationships\": [\n              {\n                \"id\": \"18\",\n                \"type\": \"EMPLOYED_BY\",\n                \"startNode\": \"343\",\n                \"endNode\": \"26\",\n                \"properties\": {}\n              }\n            ]\n          }\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"343\",\n                \"labels\": [\n                  \"User\"\n                ],\n                \"properties\": {\n                  \"firstName\": \"adam\"\n                }\n              },\n              {\n                \"id\": \"347\",\n                \"labels\": [\n                  \"Issue\"\n                ],\n                \"properties\": {\n                  \"title\": \"fake 7\",\n                  \"number\": \"7\",\n                  \"title\": \"fake 7\"\n                }\n              }\n            ],\n            \"relationships\": [\n              {\n                \"id\": \"506\",\n                \"type\": \"ASSIGNED_TO\",\n                \"startNode\": \"347\",\n                \"endNode\": \"343\",\n                \"properties\": {}\n              }\n            ]\n          }\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"344\",\n                \"labels\": [\n                  \"User\"\n                ],\n                \"properties\": {\n                  \"firstName\": \"vince\"\n                }\n              }\n            ],\n            \"relationships\": []\n          }\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"26\",\n                \"labels\": [\n                  \"Customer\"\n                ],\n                \"properties\": {\n                  \"name\": \"GraphAware\"\n                }\n              },\n              {\n                \"id\": \"344\",\n                \"labels\": [\n                  \"User\"\n                ],\n                \"properties\": {\n                  \"firstName\": \"vince\"\n                }\n              }\n            ],\n            \"relationships\": [\n              {\n                \"id\": \"19\",\n                \"type\": \"EMPLOYED_BY\",\n                \"startNode\": \"344\",\n                \"endNode\": \"26\",\n                \"properties\": {}\n              }\n            ]\n          }\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"346\",\n                \"labels\": [\n                  \"Issue\"\n                ],\n                \"properties\": {\n                  \"title\": \"fake 1\",\n                  \"number\": \"1\",\n                  \"title\": \"fake 1\"\n                }\n              },\n              {\n                \"id\": \"344\",\n                \"labels\": [\n                  \"User\"\n                ],\n                \"properties\": {\n                  \"firstName\": \"vince\"\n                }\n              }\n            ],\n            \"relationships\": [\n              {\n                \"id\": \"509\",\n                \"type\": \"CREATED\",\n                \"startNode\": \"344\",\n                \"endNode\": \"346\",\n                \"properties\": {}\n              }\n            ]\n          }\n        }\n      ]\n    }\n  ],\n  \"errors\": []\n}";
        return new ByteArrayInputStream("{\n  \"results\": [\n    {\n      \"columns\": [\n        \"p\"\n      ],\n      \"data\": [\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"343\",\n                \"labels\": [\n                  \"User\"\n                ],\n                \"properties\": {\n                  \"firstName\": \"adam\"\n                }\n              }\n            ],\n            \"relationships\": []\n          }\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"343\",\n                \"labels\": [\n                  \"User\"\n                ],\n                \"properties\": {\n                  \"firstName\": \"adam\"\n                }\n              },\n              {\n                \"id\": \"26\",\n                \"labels\": [\n                  \"Customer\"\n                ],\n                \"properties\": {\n                  \"name\": \"GraphAware\"\n                }\n              }\n            ],\n            \"relationships\": [\n              {\n                \"id\": \"18\",\n                \"type\": \"EMPLOYED_BY\",\n                \"startNode\": \"343\",\n                \"endNode\": \"26\",\n                \"properties\": {}\n              }\n            ]\n          }\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"343\",\n                \"labels\": [\n                  \"User\"\n                ],\n                \"properties\": {\n                  \"firstName\": \"adam\"\n                }\n              },\n              {\n                \"id\": \"347\",\n                \"labels\": [\n                  \"Issue\"\n                ],\n                \"properties\": {\n                  \"title\": \"fake 7\",\n                  \"number\": \"7\",\n                  \"title\": \"fake 7\"\n                }\n              }\n            ],\n            \"relationships\": [\n              {\n                \"id\": \"506\",\n                \"type\": \"ASSIGNED_TO\",\n                \"startNode\": \"347\",\n                \"endNode\": \"343\",\n                \"properties\": {}\n              }\n            ]\n          }\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"344\",\n                \"labels\": [\n                  \"User\"\n                ],\n                \"properties\": {\n                  \"firstName\": \"vince\"\n                }\n              }\n            ],\n            \"relationships\": []\n          }\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"26\",\n                \"labels\": [\n                  \"Customer\"\n                ],\n                \"properties\": {\n                  \"name\": \"GraphAware\"\n                }\n              },\n              {\n                \"id\": \"344\",\n                \"labels\": [\n                  \"User\"\n                ],\n                \"properties\": {\n                  \"firstName\": \"vince\"\n                }\n              }\n            ],\n            \"relationships\": [\n              {\n                \"id\": \"19\",\n                \"type\": \"EMPLOYED_BY\",\n                \"startNode\": \"344\",\n                \"endNode\": \"26\",\n                \"properties\": {}\n              }\n            ]\n          }\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"346\",\n                \"labels\": [\n                  \"Issue\"\n                ],\n                \"properties\": {\n                  \"title\": \"fake 1\",\n                  \"number\": \"1\",\n                  \"title\": \"fake 1\"\n                }\n              },\n              {\n                \"id\": \"344\",\n                \"labels\": [\n                  \"User\"\n                ],\n                \"properties\": {\n                  \"firstName\": \"vince\"\n                }\n              }\n            ],\n            \"relationships\": [\n              {\n                \"id\": \"509\",\n                \"type\": \"CREATED\",\n                \"startNode\": \"344\",\n                \"endNode\": \"346\",\n                \"properties\": {}\n              }\n            ]\n          }\n        }\n      ]\n    }\n  ],\n  \"errors\": []\n}".getBytes(StandardCharsets.UTF_8));
    }

    static class TestGraphHttpResponse
    extends AbstractHttpResponse<ResultGraphModel>
    implements Response<GraphModel> {
        public TestGraphHttpResponse() {
            super(response, ResultGraphModel.class);
        }

        public GraphModel next() {
            ResultGraphModel graphModel = (ResultGraphModel)this.nextDataRecord("graph");
            if (graphModel != null) {
                return graphModel.queryResults();
            }
            return null;
        }

        public void close() {
        }
    }
}

