/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.http.response;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.ogm.drivers.http.response.AbstractHttpResponse;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.model.GraphRowListModel;
import org.neo4j.ogm.model.GraphRowModel;
import org.neo4j.ogm.model.Node;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.response.model.DefaultGraphRowListModel;
import org.neo4j.ogm.result.ResultGraphRowListModel;

public class JsonGraphRowResponseTest {
    private static CloseableHttpResponse response = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
    private static HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);

    @Before
    public void setUpMocks() {
        Mockito.when((Object)response.getEntity()).thenReturn((Object)entity);
    }

    @Test
    public void shouldParseDataInFilterGraphResponseCorrectly() throws IOException {
        Mockito.when((Object)entity.getContent()).thenReturn((Object)this.filterQueryGraphRowResponse());
        try (TestGraphRowHttpResponse rsp = new TestGraphRowHttpResponse();){
            GraphRowListModel graphRowListModel = (GraphRowListModel)rsp.next();
            Assertions.assertThat((Object)graphRowListModel).isNotNull();
            List graphRowModels = graphRowListModel.model();
            Assertions.assertThat((List)graphRowModels).hasSize(8);
            GraphRowModel model = (GraphRowModel)graphRowModels.get(0);
            GraphModel graph = model.getGraph();
            Assertions.assertThat((Long)((Node)graph.getNodes().iterator().next()).getId()).isEqualTo((Object)26L);
            Assertions.assertThat((Iterable)graph.getRelationships()).isEmpty();
            Object[] rows = model.getRow();
            Assertions.assertThat((int)rows.length).isEqualTo(2);
            Map row1 = (Map)((List)rows[0]).get(0);
            Assertions.assertThat(row1.get("name")).isEqualTo((Object)"GraphAware");
            Assertions.assertThat((Object)rows[1]).isEqualTo((Object)26L);
        }
    }

    private InputStream filterQueryGraphRowResponse() {
        String s = "{\n  \"results\": [\n    {\n      \"columns\": [\n        \"p\",\n        \"ID(n)\"\n      ],\n      \"data\": [\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"26\",\n                \"labels\": [\n                  \"Customer\"\n                ],\n                \"properties\": {\n                  \"name\": \"GraphAware\"\n                }\n              }\n            ],\n            \"relationships\": []\n          },\n          \"row\": [\n            [\n              {\n                \"name\": \"GraphAware\"\n              }\n            ],\n            26\n          ]\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"26\",\n                \"labels\": [\n                  \"Customer\"\n                ],\n                \"properties\": {\n                  \"name\": \"GraphAware\"\n                }\n              },\n              {\n                \"id\": \"344\",\n                \"labels\": [\n                  \"User\"\n                ],\n                \"properties\": {\n                  \"firstName\": \"vince\"\n                }\n              }\n            ],\n            \"relationships\": [\n              {\n                \"id\": \"19\",\n                \"type\": \"EMPLOYED_BY\",\n                \"startNode\": \"344\",\n                \"endNode\": \"26\",\n                \"properties\": {}\n              }\n            ]\n          },\n          \"row\": [\n            [\n              {\n                \"name\": \"GraphAware\"\n              },\n              {},\n              {\n                \"firstName\": \"vince\"\n              }\n            ],\n            26\n          ]\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"343\",\n                \"labels\": [\n                  \"User\"\n                ],\n                \"properties\": {\n                  \"firstName\": \"adam\"\n                }\n              },\n              {\n                \"id\": \"26\",\n                \"labels\": [\n                  \"Customer\"\n                ],\n                \"properties\": {\n                  \"name\": \"GraphAware\"\n                }\n              }\n            ],\n            \"relationships\": [\n              {\n                \"id\": \"18\",\n                \"type\": \"EMPLOYED_BY\",\n                \"startNode\": \"343\",\n                \"endNode\": \"26\",\n                \"properties\": {}\n              }\n            ]\n          },\n          \"row\": [\n            [\n              {\n                \"name\": \"GraphAware\"\n              },\n              {},\n              {\n                \"firstName\": \"adam\"\n              }\n            ],\n            26\n          ]\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"26\",\n                \"labels\": [\n                  \"Customer\"\n                ],\n                \"properties\": {\n                  \"name\": \"GraphAware\"\n                }\n              },\n              {\n                \"id\": \"346\",\n                \"labels\": [\n                  \"Issue\"\n                ],\n                \"properties\": {\n                  \"title\": \"fake 1\",\n                  \"number\": \"1\",\n                  \"title\": \"fake 1\"\n                }\n              }\n            ],\n            \"relationships\": [\n              {\n                \"id\": \"20\",\n                \"type\": \"LOGGED_BY\",\n                \"startNode\": \"346\",\n                \"endNode\": \"26\",\n                \"properties\": {}\n              }\n            ]\n          },\n          \"row\": [\n            [\n              {\n                \"name\": \"GraphAware\"\n              },\n              {},\n              {\n                \"title\": \"fake 1\",\n                \"number\": \"1\",\n                \"title\": \"fake 1\"\n              }\n            ],\n            26\n          ]\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"26\",\n                \"labels\": [\n                  \"Customer\"\n                ],\n                \"properties\": {\n                  \"name\": \"GraphAware\"\n                }\n              },\n              {\n                \"id\": \"347\",\n                \"labels\": [\n                  \"Issue\"\n                ],\n                \"properties\": {\n                  \"title\": \"fake 7\",\n                  \"number\": \"7\",\n                  \"title\": \"fake 7\"\n                }\n              }\n            ],\n            \"relationships\": [\n              {\n                \"id\": \"501\",\n                \"type\": \"LOGGED_BY\",\n                \"startNode\": \"347\",\n                \"endNode\": \"26\",\n                \"properties\": {}\n              }\n            ]\n          },\n          \"row\": [\n            [\n              {\n                \"name\": \"GraphAware\"\n              },\n              {},\n              {\n                \"title\": \"fake 7\",\n                \"number\": \"7\",\n                \"title\": \"fake 7\"\n              }\n            ],\n            26\n          ]\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"27\",\n                \"labels\": [\n                  \"Company\"\n                ],\n                \"properties\": {\n                  \"name\": \"Acme\"\n                }\n              },\n              {\n                \"id\": \"26\",\n                \"labels\": [\n                  \"Customer\"\n                ],\n                \"properties\": {\n                  \"name\": \"GraphAware\"\n                }\n              }\n            ],\n            \"relationships\": [\n              {\n                \"id\": \"502\",\n                \"type\": \"LOCATED_AT\",\n                \"startNode\": \"26\",\n                \"endNode\": \"27\",\n                \"properties\": {}\n              }\n            ]\n          },\n          \"row\": [\n            [\n              {\n                \"name\": \"GraphAware\"\n              },\n              {},\n              {\n                \"name\": \"Acme\"\n              }\n            ],\n            26\n          ]\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"26\",\n                \"labels\": [\n                  \"Customer\"\n                ],\n                \"properties\": {\n                  \"name\": \"GraphAware\"\n                }\n              },\n              {\n                \"id\": \"28\",\n                \"labels\": [\n                  \"Company\"\n                ],\n                \"properties\": {\n                  \"name\": \"CodeIsUs\"\n                }\n              }\n            ],\n            \"relationships\": [\n              {\n                \"id\": \"503\",\n                \"type\": \"LOCATED_AT\",\n                \"startNode\": \"26\",\n                \"endNode\": \"28\",\n                \"properties\": {}\n              }\n            ]\n          },\n          \"row\": [\n            [\n              {\n                \"name\": \"GraphAware\"\n              },\n              {},\n              {\n                \"name\": \"CodeIsUs\"\n              }\n            ],\n            26\n          ]\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"0\",\n                \"labels\": [\n                  \"Issue\"\n                ],\n                \"properties\": {\n                  \"number\": \"8\",\n                  \"title\": \"fake 8\"\n                }\n              },\n              {\n                \"id\": \"26\",\n                \"labels\": [\n                  \"Customer\"\n                ],\n                \"properties\": {\n                  \"name\": \"GraphAware\"\n                }\n              }\n            ],\n            \"relationships\": [\n              {\n                \"id\": \"520\",\n                \"type\": \"LOGGED_BY\",\n                \"startNode\": \"0\",\n                \"endNode\": \"26\",\n                \"properties\": {}\n              }\n            ]\n          },\n          \"row\": [\n            [\n              {\n                \"name\": \"GraphAware\"\n              },\n              {},\n              {\n                \"number\": \"8\",\n                \"title\": \"fake 8\"\n              }\n            ],\n            26\n          ]\n        }\n      ]\n    }\n  ],\n  \"errors\": []\n}";
        return new ByteArrayInputStream("{\n  \"results\": [\n    {\n      \"columns\": [\n        \"p\",\n        \"ID(n)\"\n      ],\n      \"data\": [\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"26\",\n                \"labels\": [\n                  \"Customer\"\n                ],\n                \"properties\": {\n                  \"name\": \"GraphAware\"\n                }\n              }\n            ],\n            \"relationships\": []\n          },\n          \"row\": [\n            [\n              {\n                \"name\": \"GraphAware\"\n              }\n            ],\n            26\n          ]\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"26\",\n                \"labels\": [\n                  \"Customer\"\n                ],\n                \"properties\": {\n                  \"name\": \"GraphAware\"\n                }\n              },\n              {\n                \"id\": \"344\",\n                \"labels\": [\n                  \"User\"\n                ],\n                \"properties\": {\n                  \"firstName\": \"vince\"\n                }\n              }\n            ],\n            \"relationships\": [\n              {\n                \"id\": \"19\",\n                \"type\": \"EMPLOYED_BY\",\n                \"startNode\": \"344\",\n                \"endNode\": \"26\",\n                \"properties\": {}\n              }\n            ]\n          },\n          \"row\": [\n            [\n              {\n                \"name\": \"GraphAware\"\n              },\n              {},\n              {\n                \"firstName\": \"vince\"\n              }\n            ],\n            26\n          ]\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"343\",\n                \"labels\": [\n                  \"User\"\n                ],\n                \"properties\": {\n                  \"firstName\": \"adam\"\n                }\n              },\n              {\n                \"id\": \"26\",\n                \"labels\": [\n                  \"Customer\"\n                ],\n                \"properties\": {\n                  \"name\": \"GraphAware\"\n                }\n              }\n            ],\n            \"relationships\": [\n              {\n                \"id\": \"18\",\n                \"type\": \"EMPLOYED_BY\",\n                \"startNode\": \"343\",\n                \"endNode\": \"26\",\n                \"properties\": {}\n              }\n            ]\n          },\n          \"row\": [\n            [\n              {\n                \"name\": \"GraphAware\"\n              },\n              {},\n              {\n                \"firstName\": \"adam\"\n              }\n            ],\n            26\n          ]\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"26\",\n                \"labels\": [\n                  \"Customer\"\n                ],\n                \"properties\": {\n                  \"name\": \"GraphAware\"\n                }\n              },\n              {\n                \"id\": \"346\",\n                \"labels\": [\n                  \"Issue\"\n                ],\n                \"properties\": {\n                  \"title\": \"fake 1\",\n                  \"number\": \"1\",\n                  \"title\": \"fake 1\"\n                }\n              }\n            ],\n            \"relationships\": [\n              {\n                \"id\": \"20\",\n                \"type\": \"LOGGED_BY\",\n                \"startNode\": \"346\",\n                \"endNode\": \"26\",\n                \"properties\": {}\n              }\n            ]\n          },\n          \"row\": [\n            [\n              {\n                \"name\": \"GraphAware\"\n              },\n              {},\n              {\n                \"title\": \"fake 1\",\n                \"number\": \"1\",\n                \"title\": \"fake 1\"\n              }\n            ],\n            26\n          ]\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"26\",\n                \"labels\": [\n                  \"Customer\"\n                ],\n                \"properties\": {\n                  \"name\": \"GraphAware\"\n                }\n              },\n              {\n                \"id\": \"347\",\n                \"labels\": [\n                  \"Issue\"\n                ],\n                \"properties\": {\n                  \"title\": \"fake 7\",\n                  \"number\": \"7\",\n                  \"title\": \"fake 7\"\n                }\n              }\n            ],\n            \"relationships\": [\n              {\n                \"id\": \"501\",\n                \"type\": \"LOGGED_BY\",\n                \"startNode\": \"347\",\n                \"endNode\": \"26\",\n                \"properties\": {}\n              }\n            ]\n          },\n          \"row\": [\n            [\n              {\n                \"name\": \"GraphAware\"\n              },\n              {},\n              {\n                \"title\": \"fake 7\",\n                \"number\": \"7\",\n                \"title\": \"fake 7\"\n              }\n            ],\n            26\n          ]\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"27\",\n                \"labels\": [\n                  \"Company\"\n                ],\n                \"properties\": {\n                  \"name\": \"Acme\"\n                }\n              },\n              {\n                \"id\": \"26\",\n                \"labels\": [\n                  \"Customer\"\n                ],\n                \"properties\": {\n                  \"name\": \"GraphAware\"\n                }\n              }\n            ],\n            \"relationships\": [\n              {\n                \"id\": \"502\",\n                \"type\": \"LOCATED_AT\",\n                \"startNode\": \"26\",\n                \"endNode\": \"27\",\n                \"properties\": {}\n              }\n            ]\n          },\n          \"row\": [\n            [\n              {\n                \"name\": \"GraphAware\"\n              },\n              {},\n              {\n                \"name\": \"Acme\"\n              }\n            ],\n            26\n          ]\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"26\",\n                \"labels\": [\n                  \"Customer\"\n                ],\n                \"properties\": {\n                  \"name\": \"GraphAware\"\n                }\n              },\n              {\n                \"id\": \"28\",\n                \"labels\": [\n                  \"Company\"\n                ],\n                \"properties\": {\n                  \"name\": \"CodeIsUs\"\n                }\n              }\n            ],\n            \"relationships\": [\n              {\n                \"id\": \"503\",\n                \"type\": \"LOCATED_AT\",\n                \"startNode\": \"26\",\n                \"endNode\": \"28\",\n                \"properties\": {}\n              }\n            ]\n          },\n          \"row\": [\n            [\n              {\n                \"name\": \"GraphAware\"\n              },\n              {},\n              {\n                \"name\": \"CodeIsUs\"\n              }\n            ],\n            26\n          ]\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"0\",\n                \"labels\": [\n                  \"Issue\"\n                ],\n                \"properties\": {\n                  \"number\": \"8\",\n                  \"title\": \"fake 8\"\n                }\n              },\n              {\n                \"id\": \"26\",\n                \"labels\": [\n                  \"Customer\"\n                ],\n                \"properties\": {\n                  \"name\": \"GraphAware\"\n                }\n              }\n            ],\n            \"relationships\": [\n              {\n                \"id\": \"520\",\n                \"type\": \"LOGGED_BY\",\n                \"startNode\": \"0\",\n                \"endNode\": \"26\",\n                \"properties\": {}\n              }\n            ]\n          },\n          \"row\": [\n            [\n              {\n                \"name\": \"GraphAware\"\n              },\n              {},\n              {\n                \"number\": \"8\",\n                \"title\": \"fake 8\"\n              }\n            ],\n            26\n          ]\n        }\n      ]\n    }\n  ],\n  \"errors\": []\n}".getBytes(StandardCharsets.UTF_8));
    }

    static class TestGraphRowHttpResponse
    extends AbstractHttpResponse<ResultGraphRowListModel>
    implements Response<GraphRowListModel> {
        public TestGraphRowHttpResponse() {
            super(response, ResultGraphRowListModel.class);
        }

        public GraphRowListModel next() {
            ResultGraphRowListModel graphRowModel = (ResultGraphRowListModel)this.nextDataRecord("data");
            if (graphRowModel != null) {
                DefaultGraphRowListModel graphRowListModel = new DefaultGraphRowListModel();
                for (GraphRowModel model : graphRowModel.getData()) {
                    graphRowListModel.add(model);
                }
                return graphRowListModel;
            }
            return null;
        }

        public void close() {
        }
    }
}

