/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.http.response;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.ogm.drivers.http.response.AbstractHttpResponse;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.response.model.DefaultRowModel;
import org.neo4j.ogm.result.ResultRowModel;

public class JsonRowResponseTest {
    private static CloseableHttpResponse response = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
    private static HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);

    @Before
    public void setUpMocks() {
        Mockito.when((Object)response.getEntity()).thenReturn((Object)entity);
    }

    @Test
    public void shouldParseColumnsInRowResponseCorrectly() throws IOException {
        Mockito.when((Object)entity.getContent()).thenReturn((Object)this.rowResultsAndNoErrors());
        try (TestRowHttpResponse rsp = new TestRowHttpResponse();){
            Assertions.assertThat((int)rsp.columns().length).isEqualTo(1);
            Assertions.assertThat((String)rsp.columns()[0]).isEqualTo((Object)"collect(p)");
        }
    }

    @Test
    public void shouldParseColumnsInRowResponseWithNoColumnsCorrectly() throws IOException {
        Mockito.when((Object)entity.getContent()).thenReturn((Object)this.noRowResultsAndNoErrors());
        try (TestRowHttpResponse rsp = new TestRowHttpResponse();){
            Assertions.assertThat((int)rsp.columns().length).isEqualTo(1);
            Assertions.assertThat((String)rsp.columns()[0]).isEqualTo((Object)"collect(p)");
        }
    }

    @Test
    public void shouldParseDataInRowResponseCorrectly() throws IOException {
        Mockito.when((Object)entity.getContent()).thenReturn((Object)this.rowResultsAndNoErrors());
        try (TestRowHttpResponse rsp = new TestRowHttpResponse();){
            DefaultRowModel rowModel = (DefaultRowModel)rsp.next();
            Assertions.assertThat((Object)rowModel).isNotNull();
            Object[] rows = rowModel.getValues();
            Assertions.assertThat((int)rows.length).isEqualTo(1);
            List data = (List)rows[0];
            Assertions.assertThat(((Map)((List)data.get(0)).get(0)).get("name")).isEqualTo((Object)"My Test");
        }
    }

    @Test
    public void shouldParseDataInCreateRowResponseCorrectly() throws IOException {
        Mockito.when((Object)entity.getContent()).thenReturn((Object)this.createRowResults());
        try (TestRowHttpResponse rsp = new TestRowHttpResponse();){
            DefaultRowModel rowModel = (DefaultRowModel)rsp.next();
            Assertions.assertThat((Object)rowModel).isNotNull();
            Object[] rows = rowModel.getValues();
            Assertions.assertThat((int)rows.length).isEqualTo(4);
            Assertions.assertThat((Object)rows[0]).isEqualTo((Object)388L);
            Assertions.assertThat((Object)rows[1]).isEqualTo((Object)527L);
            Assertions.assertThat((Object)rows[2]).isEqualTo((Object)389L);
            Assertions.assertThat((Object)rows[3]).isEqualTo((Object)528L);
        }
    }

    @Test
    public void shouldParseDataInCustomQueryRowResponseCorrectly() throws IOException {
        Mockito.when((Object)entity.getContent()).thenReturn((Object)this.customQueryRowResults());
        try (TestRowHttpResponse rsp = new TestRowHttpResponse();){
            DefaultRowModel rowModel = (DefaultRowModel)rsp.next();
            Assertions.assertThat((Object)rowModel).isNotNull();
            Object[] rows = rowModel.getValues();
            Assertions.assertThat((int)rows.length).isEqualTo(3);
            Map obj1 = (Map)rows[0];
            Assertions.assertThat(obj1.get("name")).isEqualTo((Object)"Betty");
            Assertions.assertThat((Map)((Map)rows[1])).isEmpty();
            Assertions.assertThat((String)((String)rows[2])).isEqualTo((Object)"Peter");
        }
    }

    private InputStream rowResultsAndNoErrors() {
        String s = "{\"results\": [{\"columns\": [\"collect(p)\"],\"data\": [{\"row\": [[[{\"name\": \"My Test\"}]]]}]}],\"errors\": []}";
        return new ByteArrayInputStream("{\"results\": [{\"columns\": [\"collect(p)\"],\"data\": [{\"row\": [[[{\"name\": \"My Test\"}]]]}]}],\"errors\": []}".getBytes(StandardCharsets.UTF_8));
    }

    private InputStream noRowResultsAndNoErrors() {
        String s = "{\"results\": [{\"columns\": [\"collect(p)\"],\"data\": [{\"row\": [[]]}]}],\"errors\": []}";
        return new ByteArrayInputStream("{\"results\": [{\"columns\": [\"collect(p)\"],\"data\": [{\"row\": [[]]}]}],\"errors\": []}".getBytes(StandardCharsets.UTF_8));
    }

    private InputStream createRowResults() {
        String s = "{\n  \"results\": [\n    {\n      \"columns\": [\n        \"_0\",\n        \"_1\",\n        \"_2\",\n        \"_3\"\n      ],\n      \"data\": [\n        {\n          \"row\": [\n            388,\n            527,\n            389,\n            528\n          ]\n        }\n      ]\n    }\n  ],\n  \"errors\": []\n}";
        return new ByteArrayInputStream("{\n  \"results\": [\n    {\n      \"columns\": [\n        \"_0\",\n        \"_1\",\n        \"_2\",\n        \"_3\"\n      ],\n      \"data\": [\n        {\n          \"row\": [\n            388,\n            527,\n            389,\n            528\n          ]\n        }\n      ]\n    }\n  ],\n  \"errors\": []\n}".getBytes(StandardCharsets.UTF_8));
    }

    private InputStream customQueryRowResults() {
        String s = "{\n  \"results\": [\n    {\n      \"columns\": [\n        \"n\",\n        \"r\",\n        \"m.name\"\n      ],\n      \"data\": [\n        {\n          \"row\": [\n            {\n              \"name\": \"Betty\"\n            },\n            {},\n            \"Peter\"\n          ]\n        },\n        {\n          \"row\": [\n            {\n              \"name\": \"Betty\"\n            },\n            {},\n            \"Patrick\"\n          ]\n        },\n        {\n          \"row\": [\n            {\n              \"name\": \"Betty\"\n            },\n            {},\n            \"Priscilla\"\n          ]\n        }\n      ]\n    }\n  ],\n  \"errors\": []\n}";
        return new ByteArrayInputStream("{\n  \"results\": [\n    {\n      \"columns\": [\n        \"n\",\n        \"r\",\n        \"m.name\"\n      ],\n      \"data\": [\n        {\n          \"row\": [\n            {\n              \"name\": \"Betty\"\n            },\n            {},\n            \"Peter\"\n          ]\n        },\n        {\n          \"row\": [\n            {\n              \"name\": \"Betty\"\n            },\n            {},\n            \"Patrick\"\n          ]\n        },\n        {\n          \"row\": [\n            {\n              \"name\": \"Betty\"\n            },\n            {},\n            \"Priscilla\"\n          ]\n        }\n      ]\n    }\n  ],\n  \"errors\": []\n}".getBytes(StandardCharsets.UTF_8));
    }

    static class TestRowHttpResponse
    extends AbstractHttpResponse<ResultRowModel>
    implements Response<DefaultRowModel> {
        TestRowHttpResponse() {
            super(response, ResultRowModel.class);
        }

        public DefaultRowModel next() {
            ResultRowModel rowModel = (ResultRowModel)this.nextDataRecord("row");
            if (rowModel != null) {
                return new DefaultRowModel(rowModel.queryResults(), this.columns());
            }
            return null;
        }

        public void close() {
        }
    }
}

