/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.metadata.AnnotationInfo;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.MetaData;

public class AnnotationsTest {
    @Test
    public void shouldLoadMetaDataWithComplexAnnotations() {
        MetaData metaData = new MetaData(new String[]{"org.neo4j.ogm.domain.annotations"});
        Assertions.assertThat((String)metaData.classInfo("SimpleNode").name()).isEqualTo((Object)"org.neo4j.ogm.domain.annotations.SimpleNode");
        Assertions.assertThat((String)metaData.classInfo("OtherNode").name()).isEqualTo((Object)"org.neo4j.ogm.domain.annotations.OtherNode");
    }

    @Test
    public void shouldReadIndexAnnotationElement() {
        MetaData metaData = new MetaData(new String[]{"org.neo4j.ogm.domain.annotations"});
        ClassInfo classInfo = metaData.classInfo("IndexedEntity");
        FieldInfo fieldInfo = classInfo.propertyField("ref");
        AnnotationInfo annotationInfo = fieldInfo.getAnnotations().get("org.neo4j.ogm.domain.annotations.IndexedEntity$Indexed");
        Assertions.assertThat((String)annotationInfo.get("b", "")).isEqualTo((Object)"97");
        Assertions.assertThat((String)annotationInfo.get("c", "")).isEqualTo((Object)"1");
        Assertions.assertThat((String)annotationInfo.get("t", "")).isEqualTo((Object)"t");
        Assertions.assertThat((String)annotationInfo.get("d", "0.0d")).isEqualTo((Object)"0.01");
        Assertions.assertThat((String)annotationInfo.get("f", "0.0f")).isEqualTo((Object)"0.02");
        Assertions.assertThat((String)annotationInfo.get("s", "0")).isEqualTo((Object)"3");
        Assertions.assertThat((String)annotationInfo.get("i", "0")).isEqualTo((Object)"5");
        Assertions.assertThat((String)annotationInfo.get("j", "0")).isEqualTo((Object)"6");
        Assertions.assertThat((String)annotationInfo.get("z", "false")).isEqualTo((Object)"true");
    }
}

