/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.ogm.metadata.DomainInfo;

public class ClassPathScannerTest {
    @Test
    public void directoryShouldBeScanned() {
        DomainInfo domainInfo = DomainInfo.create((String[])new String[]{"org.neo4j.ogm.domain.bike"});
        Assertions.assertThat((Map)domainInfo.getClassInfoMap()).hasSize(5);
        Set classNames = domainInfo.getClassInfoMap().keySet();
        Assertions.assertThat((boolean)classNames.contains("org.neo4j.ogm.domain.bike.Bike")).isTrue();
        Assertions.assertThat((boolean)classNames.contains("org.neo4j.ogm.domain.bike.Frame")).isTrue();
        Assertions.assertThat((boolean)classNames.contains("org.neo4j.ogm.domain.bike.Saddle")).isTrue();
        Assertions.assertThat((boolean)classNames.contains("org.neo4j.ogm.domain.bike.Wheel")).isTrue();
        Assertions.assertThat((boolean)classNames.contains("org.neo4j.ogm.domain.bike.WheelWithUUID")).isTrue();
    }

    @Test
    public void nestedDirectoryShouldBeScanned() {
        DomainInfo domainInfo = DomainInfo.create((String[])new String[]{"org.neo4j.ogm.domain.convertible"});
        Assertions.assertThat((Map)domainInfo.getClassInfoMap()).hasSize(21);
        Set classNames = domainInfo.getClassInfoMap().keySet();
        Assertions.assertThat((boolean)classNames.contains("org.neo4j.ogm.domain.convertible.bytes.Photo")).isTrue();
        Assertions.assertThat((boolean)classNames.contains("org.neo4j.ogm.domain.convertible.bytes.PhotoWrapper")).isTrue();
        Assertions.assertThat((boolean)classNames.contains("org.neo4j.ogm.domain.convertible.date.DateNumericStringConverter")).isTrue();
        Assertions.assertThat((boolean)classNames.contains("org.neo4j.ogm.domain.convertible.date.Memo")).isTrue();
        Assertions.assertThat((boolean)classNames.contains("org.neo4j.ogm.domain.convertible.date.Java8DatesMemo")).isTrue();
        Assertions.assertThat((boolean)classNames.contains("org.neo4j.ogm.domain.convertible.enums.Algebra")).isTrue();
        Assertions.assertThat((boolean)classNames.contains("org.neo4j.ogm.domain.convertible.enums.Education")).isTrue();
        Assertions.assertThat((boolean)classNames.contains("org.neo4j.ogm.domain.convertible.enums.Gender")).isTrue();
        Assertions.assertThat((boolean)classNames.contains("org.neo4j.ogm.domain.convertible.enums.NumberSystem")).isTrue();
        Assertions.assertThat((boolean)classNames.contains("org.neo4j.ogm.domain.convertible.enums.NumberSystemDomainConverter")).isTrue();
        Assertions.assertThat((boolean)classNames.contains("org.neo4j.ogm.domain.convertible.enums.Operation")).isTrue();
        Assertions.assertThat((boolean)classNames.contains("org.neo4j.ogm.domain.convertible.enums.Person")).isTrue();
        Assertions.assertThat((boolean)classNames.contains("org.neo4j.ogm.domain.convertible.enums.Tag")).isTrue();
        Assertions.assertThat((boolean)classNames.contains("org.neo4j.ogm.domain.convertible.enums.TagEntity")).isTrue();
        Assertions.assertThat((boolean)classNames.contains("org.neo4j.ogm.domain.convertible.enums.TagModel")).isTrue();
        Assertions.assertThat((boolean)classNames.contains("org.neo4j.ogm.domain.convertible.numbers.Account")).isTrue();
        Assertions.assertThat((boolean)classNames.contains("org.neo4j.ogm.domain.convertible.parametrized.JsonNode")).isTrue();
        Assertions.assertThat((boolean)classNames.contains("org.neo4j.ogm.domain.convertible.parametrized.MapJson")).isTrue();
        Assertions.assertThat((boolean)classNames.contains("org.neo4j.ogm.domain.convertible.parametrized.StringMapEntity")).isTrue();
        Assertions.assertThat((boolean)classNames.contains("org.neo4j.ogm.domain.convertible.parametrized.StringMapConverter")).isTrue();
    }

    @Test
    public void zipFileWithDomainClassesShouldBeScanned() throws IOException {
        DomainInfo domainInfo = DomainInfo.create((String[])new String[]{"concert.domain"});
        Assertions.assertThat((Map)domainInfo.getClassInfoMap()).hasSize(2);
        Set classNames = domainInfo.getClassInfoMap().keySet();
        Assertions.assertThat((boolean)classNames.contains("concert.domain.Concert")).isTrue();
        Assertions.assertThat((boolean)classNames.contains("concert.domain.Fan")).isTrue();
    }

    @Test
    @Ignore(value="Work with Luke to see what needs to happen here.")
    public void domainClassesInNestedZipShouldBeScanned() {
        DomainInfo domainInfo = DomainInfo.create((String[])new String[]{"radio.domain"});
        Assertions.assertThat((Map)domainInfo.getClassInfoMap()).hasSize(2);
        Set classNames = domainInfo.getClassInfoMap().keySet();
        Assertions.assertThat((boolean)classNames.contains("radio.domain.Station")).isTrue();
        Assertions.assertThat((boolean)classNames.contains("radio.domain.Channel")).isTrue();
    }

    @Test
    @Ignore(value="Work with Luke to see what needs to happen here.")
    public void domainClassesInDirectoryInNestedZipShouldBeScanned() {
        DomainInfo domainInfo = DomainInfo.create((String[])new String[]{"event.domain"});
        Assertions.assertThat((Map)domainInfo.getClassInfoMap()).hasSize(1);
        Set classNames = domainInfo.getClassInfoMap().keySet();
        Assertions.assertThat((boolean)classNames.contains("event.domain.Show")).isTrue();
    }
}

