/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.io.Serializable;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.domain.gh492.BaseUser;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.metadata.POJO;
import org.neo4j.ogm.metadata.TestMetaDataTypeResolution;

public class GenericsFieldsTest
extends TestMetaDataTypeResolution {
    @Test
    public void testUnboundedGeneric() {
        this.checkField("genericObject", "java.lang.Object", Object.class);
    }

    @Test
    public void testGenericComparable() {
        this.checkField("genericComparable", "java.lang.Comparable", Comparable.class);
    }

    @Test
    public void testGenericSerializable() {
        this.checkField("genericSerializable", "java.io.Serializable", Serializable.class);
    }

    @Test
    public void testGenericSelfReference() {
        this.checkField("next", "org.neo4j.ogm.metadata.POJO", POJO.class);
    }

    @Test
    public void testCollectionWithUnboundGenericParameter() {
        this.checkField("elements", "java.lang.Object", Object.class);
    }

    @Test
    public void testCollectionWithConcreteParameterizedType() {
        this.checkField("neighbours", "org.neo4j.ogm.metadata.POJO", POJO.class);
    }

    @Test
    public void testCollectionWithExtendedConcreteParameterizedType() {
        this.checkField("superIntegers", "java.lang.Object", Object.class);
    }

    @Test
    public void testCollectionWithReducedConcreteParameterizedType() {
        this.checkField("subIntegers", "java.lang.Object", Object.class);
    }

    @Test
    public void testCollectionOfWildcardExtendingGenericType() {
        this.checkField("superS", "java.lang.Object", Object.class);
    }

    @Test
    public void testCollectionOfWildcardReducingGenericType() {
        this.checkField("subS", "java.lang.Object", Object.class);
    }

    @Test
    public void testListGenericWildcard() {
        this.checkField("listOfAnything", "java.lang.Object", Object.class);
    }

    @Test
    public void testVectorGenericWildcard() {
        this.checkField("vectorOfAnything", "java.lang.Object", Object.class);
    }

    @Test
    public void testSetGenericWildcard() {
        this.checkField("setOfAnything", "java.lang.Object", Object.class);
    }

    @Test
    public void testIterableOfMapOfParameterizedClasses() {
        this.checkField("iterable", "java.util.Map", Map.class);
    }

    @Test
    public void shouldDetectPrimitiveArraysInGenericFields() {
        MetaData metaData = new MetaData(new String[]{"org.neo4j.ogm.domain.gh492"});
        ClassInfo classInfo = metaData.classInfo(BaseUser.IntUser.class);
        FieldInfo fieldInfo = classInfo.getFieldInfo("genericValue");
        Assertions.assertThat((boolean)fieldInfo.isArray()).isTrue();
        Assertions.assertThat((Class)fieldInfo.type()).isEqualTo(int[].class);
    }

    @Test
    public void shouldDetectWrapperArraysInGenericFields() {
        MetaData metaData = new MetaData(new String[]{"org.neo4j.ogm.domain.gh492"});
        ClassInfo classInfo = metaData.classInfo(BaseUser.IntegerUser.class);
        FieldInfo fieldInfo = classInfo.getFieldInfo("genericValue");
        Assertions.assertThat((boolean)fieldInfo.isArray()).isTrue();
        Assertions.assertThat((Class)fieldInfo.type()).isEqualTo(Integer[].class);
    }
}

