/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.domain.annotations.ids.ValidAnnotations;
import org.neo4j.ogm.domain.invalid.ids.InvalidAnnotations;
import org.neo4j.ogm.exception.core.MappingException;
import org.neo4j.ogm.id.IdStrategy;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class IdGenerationTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.annotations.ids", "org.neo4j.ogm.domain.annotations.invalid.ids"});
    }

    @Before
    public void setUp() {
        this.session = sessionFactory.openSession();
    }

    @Test
    public void saveWithoutIdAnnotation() {
        ValidAnnotations.InternalId entity = new ValidAnnotations.InternalId();
        this.session.save((Object)entity);
        Assertions.assertThat((Long)entity.id).isNotNull();
        Session session2 = sessionFactory.openSession();
        ValidAnnotations.InternalId loaded = (ValidAnnotations.InternalId)session2.load(ValidAnnotations.InternalId.class, (Serializable)entity.id);
        Assertions.assertThat((Object)loaded).isNotNull();
        ((AbstractLongAssert)Assertions.assertThat((Long)loaded.id).isNotNull()).isEqualTo((Object)entity.id);
    }

    @Test
    public void saveInternalIdWithAnnotation() throws Exception {
        ValidAnnotations.InternalIdWithAnnotation entity = new ValidAnnotations.InternalIdWithAnnotation();
        this.session.save((Object)entity);
        Assertions.assertThat((Long)entity.identifier).isNotNull();
        this.session.clear();
        ValidAnnotations.InternalIdWithAnnotation loaded = (ValidAnnotations.InternalIdWithAnnotation)this.session.load(ValidAnnotations.InternalIdWithAnnotation.class, (Serializable)entity.identifier);
        Assertions.assertThat((Object)loaded).isNotNull();
        Assertions.assertThat((Long)loaded.identifier).isEqualTo((Object)entity.identifier);
    }

    @Test
    public void saveWithStringUuidGeneration() {
        ValidAnnotations.IdAndGenerationType entity = new ValidAnnotations.IdAndGenerationType();
        this.session.save((Object)entity);
        Assertions.assertThat((String)entity.identifier).isNotNull();
        Session session2 = sessionFactory.openSession();
        ValidAnnotations.IdAndGenerationType retrievedEntity = (ValidAnnotations.IdAndGenerationType)session2.load(ValidAnnotations.IdAndGenerationType.class, (Serializable)((Object)entity.identifier));
        Assertions.assertThat((Object)retrievedEntity).isNotNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)retrievedEntity.identifier).isNotNull()).isEqualTo((Object)entity.identifier);
    }

    @Test
    public void saveWithUuidGeneration() {
        ValidAnnotations.UuidIdAndGenerationType entity = new ValidAnnotations.UuidIdAndGenerationType();
        this.session.save((Object)entity);
        Assertions.assertThat((Comparable)entity.identifier).isNotNull();
        Session session2 = sessionFactory.openSession();
        ValidAnnotations.UuidIdAndGenerationType retrievedEntity = (ValidAnnotations.UuidIdAndGenerationType)session2.load(ValidAnnotations.UuidIdAndGenerationType.class, (Serializable)entity.identifier);
        Assertions.assertThat((Object)retrievedEntity).isNotNull();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)retrievedEntity.identifier).isNotNull()).isEqualTo((Object)entity.identifier);
    }

    @Test
    public void deleteByEntityShouldWorkWithUserTypedIdsInNewSession() {
        ValidAnnotations.UuidIdAndGenerationTypeWithoutIdAttribute entity = new ValidAnnotations.UuidIdAndGenerationTypeWithoutIdAttribute();
        this.session.save((Object)entity);
        Session session2 = sessionFactory.openSession();
        entity = (ValidAnnotations.UuidIdAndGenerationTypeWithoutIdAttribute)session2.load(ValidAnnotations.UuidIdAndGenerationTypeWithoutIdAttribute.class, (Serializable)entity.identifier);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("identifier", entity.identifier.toString());
        IdGenerationTest.deleteAndAssertDeletion(entity, session2, parameters);
    }

    @Test
    public void deleteByEntityShouldWorkWithUserTypedIdsInClearedSession() {
        ValidAnnotations.UuidIdAndGenerationTypeWithoutIdAttribute entity = new ValidAnnotations.UuidIdAndGenerationTypeWithoutIdAttribute();
        this.session.save((Object)entity);
        Session session2 = sessionFactory.openSession();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("identifier", entity.identifier.toString());
        IdGenerationTest.deleteAndAssertDeletion(entity, session2, parameters);
    }

    private static void deleteAndAssertDeletion(ValidAnnotations.UuidIdAndGenerationTypeWithoutIdAttribute entity, Session session2, Map<String, Object> parameters) {
        String cypher = "MATCH (e:`ValidAnnotations$UuidIdAndGenerationTypeWithoutIdAttribute` {identifier: $identifier}) RETURN count(e)";
        Assertions.assertThat((Long)((Long)session2.queryForObject(Long.class, cypher, parameters))).isEqualTo(1L);
        session2.delete((Object)entity);
        Assertions.assertThat((Object)session2.queryForObject(ValidAnnotations.UuidIdAndGenerationType.class, cypher, parameters)).isEqualTo((Object)0L);
    }

    @Test
    public void saveWithCustomStrategyGeneratesId() throws Exception {
        ValidAnnotations.WithCustomIdStrategy entity = new ValidAnnotations.WithCustomIdStrategy();
        this.session.save((Object)entity);
        Assertions.assertThat((String)entity.identifier).isEqualTo((Object)"test-custom-id");
        this.session.clear();
        ValidAnnotations.WithCustomIdStrategy loaded = (ValidAnnotations.WithCustomIdStrategy)this.session.load(ValidAnnotations.WithCustomIdStrategy.class, (Serializable)((Object)entity.identifier));
        Assertions.assertThat((Object)loaded).isNotNull();
        Assertions.assertThat((String)loaded.identifier).isEqualTo((Object)"test-custom-id");
    }

    @Test
    public void saveWithContextIdStrategy() throws Exception {
        CustomInstanceIdStrategy strategy = new CustomInstanceIdStrategy("test-custom-instance-id");
        sessionFactory.register((IdStrategy)strategy);
        ValidAnnotations.WithCustomInstanceIdStrategy entity = new ValidAnnotations.WithCustomInstanceIdStrategy();
        this.session.save((Object)entity);
        Assertions.assertThat((String)entity.identifier).isEqualTo((Object)"test-custom-instance-id");
        this.session.clear();
        ValidAnnotations.WithCustomInstanceIdStrategy loaded = (ValidAnnotations.WithCustomInstanceIdStrategy)this.session.load(ValidAnnotations.WithCustomInstanceIdStrategy.class, (Serializable)((Object)"test-custom-instance-id"));
        Assertions.assertThat((Object)loaded).isNotNull();
        Assertions.assertThat((String)loaded.identifier).isEqualTo((Object)"test-custom-instance-id");
    }

    @Test(expected=MappingException.class)
    public void saveWithCustomInstanceIdStrategyWhenStrategyNotRegistered() throws Exception {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.annotations.ids"});
        this.session = sessionFactory.openSession();
        ValidAnnotations.WithCustomInstanceIdStrategy entity = new ValidAnnotations.WithCustomInstanceIdStrategy();
        this.session.save((Object)entity);
    }

    @Test
    public void saveRelationshipEntityWithId() throws Exception {
        ValidAnnotations.IdAndGenerationType b1 = new ValidAnnotations.IdAndGenerationType();
        ValidAnnotations.IdAndGenerationType b2 = new ValidAnnotations.IdAndGenerationType();
        ValidAnnotations.RelationshipEntityWithId rel = new ValidAnnotations.RelationshipEntityWithId(b1, b2, 100);
        this.session.save((Object)rel);
        Assertions.assertThat((String)rel.uuid).isNotNull();
        ValidAnnotations.RelationshipEntityWithId loaded = (ValidAnnotations.RelationshipEntityWithId)this.session.load(ValidAnnotations.RelationshipEntityWithId.class, (Serializable)((Object)rel.uuid));
        Assertions.assertThat((Object)loaded).isSameAs((Object)rel);
        this.session.clear();
        loaded = (ValidAnnotations.RelationshipEntityWithId)this.session.load(ValidAnnotations.RelationshipEntityWithId.class, (Serializable)((Object)rel.uuid));
        Assertions.assertThat((String)loaded.startNode.identifier).isEqualTo((Object)b1.identifier);
        Assertions.assertThat((String)loaded.endNode.identifier).isEqualTo((Object)b2.identifier);
    }

    @Test
    public void shouldRejectSavingEntityWithoutId() throws Exception {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.session.save((Object)new InvalidAnnotations.NeitherGraphIdOrId())).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("is not a valid entity class");
    }

    @Test
    public void shouldRejectDeletingEntityWithoutId() throws Exception {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.session.delete((Object)new InvalidAnnotations.NeitherGraphIdOrId())).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("is not a valid entity class");
    }

    public static class CustomInstanceIdStrategy
    implements IdStrategy {
        String value;

        public CustomInstanceIdStrategy(String value) {
            this.value = value;
        }

        public Object generateId(Object entity) {
            return this.value;
        }
    }

    public static class CustomIdStrategy
    implements IdStrategy {
        public Object generateId(Object entity) {
            return "test-custom-id";
        }
    }
}

