/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.context.EntityGraphMapper;
import org.neo4j.ogm.context.EntityMapper;
import org.neo4j.ogm.context.MappingContext;
import org.neo4j.ogm.cypher.compiler.CompileContext;
import org.neo4j.ogm.cypher.compiler.Compiler;
import org.neo4j.ogm.domain.cineasts.annotated.User;
import org.neo4j.ogm.domain.pizza.Pizza;
import org.neo4j.ogm.exception.core.MetadataException;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.request.StatementFactory;
import org.neo4j.ogm.session.request.RowStatementFactory;

public class MergeWithPrimaryIndexTests {
    private static MetaData mappingMetadata;
    private static MappingContext mappingContext;
    private EntityMapper mapper;

    @BeforeClass
    public static void setUpTestDatabase() {
        mappingMetadata = new MetaData(new String[]{"org.neo4j.ogm.domain.autoindex.valid", "org.neo4j.ogm.domain.cineasts.annotated", "org.neo4j.ogm.domain.pizza"});
        mappingContext = new MappingContext(mappingMetadata);
    }

    @Before
    public void setUpMapper() {
        mappingContext = new MappingContext(mappingMetadata);
        this.mapper = new EntityGraphMapper(mappingMetadata, mappingContext);
    }

    @After
    public void cleanGraph() {
        mappingContext.clear();
    }

    @Test
    public void newNodeUsesGraphIdWhenPrimaryIndexNotPresent() {
        Pizza pizza = new Pizza("Plain");
        Assertions.assertThat((Long)pizza.getId()).isNull();
        Compiler compiler = this.mapAndCompile(pizza);
        Assertions.assertThat((boolean)compiler.hasStatementsDependentOnNewNodes()).isFalse();
        Assertions.assertThat((String)((Statement)compiler.createNodesStatements().get(0)).getStatement()).isEqualTo((Object)"UNWIND {rows} as row CREATE (n:`Pizza`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type");
    }

    @Test
    public void newNodeUsesPrimaryIndexWhenPresent() {
        User newUser = new User("bachmania", "Michal Bachman", "password");
        Assertions.assertThat((Long)newUser.getId()).isNull();
        Compiler compiler = this.mapAndCompile(newUser);
        Assertions.assertThat((boolean)compiler.hasStatementsDependentOnNewNodes()).isFalse();
        Assertions.assertThat((String)((Statement)compiler.createNodesStatements().get(0)).getStatement()).isEqualTo((Object)"UNWIND {rows} as row MERGE (n:`User`{login: row.props.login}) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type");
    }

    @Test(expected=MetadataException.class)
    public void exceptionRaisedWhenMoreThanOnePrimaryIndexDefinedInSameClass() {
        new MetaData(new String[]{"org.neo4j.ogm.domain.autoindex.invalid"}).classInfo("BadClass").primaryIndexField();
    }

    private Compiler mapAndCompile(Object object) {
        CompileContext context = this.mapper.map(object);
        Compiler compiler = context.getCompiler();
        compiler.useStatementFactory((StatementFactory)new RowStatementFactory());
        return compiler;
    }
}

