/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.ogm.exception.core.AmbiguousBaseClassException;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.MetaData;

public class MetaDataTest {
    private MetaData metaData;

    @Before
    public void setUp() {
        this.metaData = new MetaData(new String[]{"org.neo4j.ogm.domain.forum", "org.neo4j.ogm.domain.pizza", "org.neo4j.ogm.metadata", "org.neo4j.ogm.domain.canonical", "org.neo4j.ogm.domain.hierarchy.domain"});
    }

    @Test
    public void testClassInfo() {
        Assertions.assertThat((String)this.metaData.classInfo("Topic").name()).isEqualTo((Object)"org.neo4j.ogm.domain.forum.Topic");
    }

    @Test
    public void testAnnotatedClassInfo() {
        Assertions.assertThat((String)this.metaData.classInfo("User").name()).isEqualTo((Object)"org.neo4j.ogm.domain.forum.Member");
        Assertions.assertThat((String)this.metaData.classInfo("Bronze").name()).isEqualTo((Object)"org.neo4j.ogm.domain.forum.BronzeMembership");
    }

    @Test
    public void testCanResolveRelationshipEntityFromRelationshipType() {
        ClassInfo classInfo = this.metaData.resolve(new String[]{"MEMBER_OF"});
        Assertions.assertThat((Object)classInfo).as("The resolved class info shouldn't be null", new Object[0]).isNotNull();
        Assertions.assertThat((String)classInfo.name()).isEqualTo((Object)"org.neo4j.ogm.domain.canonical.ArbitraryRelationshipEntity");
    }

    @Test
    public void testCanResolveClassHierarchies() {
        ClassInfo classInfo = this.metaData.resolve(new String[]{"Login", "User"});
        Assertions.assertThat((String)classInfo.name()).isEqualTo((Object)"org.neo4j.ogm.domain.forum.Member");
    }

    @Test(expected=AmbiguousBaseClassException.class)
    public void testCannotResolveInconsistentClassHierarchies() {
        this.metaData.resolve(new String[]{"Login", "Topic"});
    }

    @Test
    public void testInterfaceWithMultipleImplTaxa() {
        Assertions.assertThat((Object)this.metaData.resolve(new String[]{"IMembership"})).isEqualTo(null);
    }

    @Test
    public void testInterfaceWithSingleImplTaxa() {
        ClassInfo classInfo = this.metaData.resolve(new String[]{"AnnotatedInterfaceWithSingleImpl"});
        Assertions.assertThat((Object)classInfo).isNotNull();
        Assertions.assertThat((String)classInfo.name()).isEqualTo((Object)"org.neo4j.ogm.domain.hierarchy.domain.annotated.AnnotatedChildWithAnnotatedInterface");
    }

    @Test
    public void testAbstractClassTaxa() {
        Assertions.assertThat((Object)this.metaData.resolve(new String[]{"Membership"})).isEqualTo(null);
    }

    @Test(expected=AmbiguousBaseClassException.class)
    public void testNoCommonLeafInTaxa() {
        this.metaData.resolve(new String[]{"Topic", "Member"});
    }

    @Test
    public void testOrderingOfTaxaIsUnimportant() {
        Assertions.assertThat((String)this.metaData.resolve(new String[]{"Bronze", "Membership", "IMembership"}).name()).isEqualTo((Object)"org.neo4j.ogm.domain.forum.BronzeMembership");
        Assertions.assertThat((String)this.metaData.resolve(new String[]{"Bronze", "IMembership", "Membership"}).name()).isEqualTo((Object)"org.neo4j.ogm.domain.forum.BronzeMembership");
        Assertions.assertThat((String)this.metaData.resolve(new String[]{"Membership", "IMembership", "Bronze"}).name()).isEqualTo((Object)"org.neo4j.ogm.domain.forum.BronzeMembership");
        Assertions.assertThat((String)this.metaData.resolve(new String[]{"Membership", "Bronze", "IMembership"}).name()).isEqualTo((Object)"org.neo4j.ogm.domain.forum.BronzeMembership");
        Assertions.assertThat((String)this.metaData.resolve(new String[]{"IMembership", "Bronze", "Membership"}).name()).isEqualTo((Object)"org.neo4j.ogm.domain.forum.BronzeMembership");
        Assertions.assertThat((String)this.metaData.resolve(new String[]{"IMembership", "Membership", "Bronze"}).name()).isEqualTo((Object)"org.neo4j.ogm.domain.forum.BronzeMembership");
    }

    @Test
    public void testLiskovSubstitutionPrinciple() {
        Assertions.assertThat((String)this.metaData.resolve(new String[]{"Member"}).name()).isEqualTo((Object)"org.neo4j.ogm.domain.forum.Member");
        Assertions.assertThat((String)this.metaData.resolve(new String[]{"Login", "Member"}).name()).isEqualTo((Object)"org.neo4j.ogm.domain.forum.Member");
        Assertions.assertThat((String)this.metaData.resolve(new String[]{"Login", "Member"}).name()).isEqualTo((Object)"org.neo4j.ogm.domain.forum.Member");
        Assertions.assertThat((String)this.metaData.resolve(new String[]{"Member", "Login"}).name()).isEqualTo((Object)"org.neo4j.ogm.domain.forum.Member");
    }

    @Test
    public void testAllNonMemberTaxa() {
        Assertions.assertThat((Object)this.metaData.resolve(new String[]{"Knight", "Baronet"})).isNull();
    }

    @Test
    public void testNonMemberAndMemberTaxa() {
        Assertions.assertThat((String)this.metaData.resolve(new String[]{"Silver", "Pewter", "Tin"}).name()).isEqualTo((Object)"org.neo4j.ogm.domain.forum.SilverMembership");
    }
}

