/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.Test;
import org.neo4j.ogm.domain.pizza.Pizza;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.MetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadSafeMetadataTest {
    private static final Logger logger = LoggerFactory.getLogger(ThreadSafeMetadataTest.class);
    private static final int THREADS = 8;
    private static final int TOTAL_RUNS = 100;

    @Test
    public void testGetFieldInfoThreadSafe() throws Exception {
        ExecutorService service = Executors.newFixedThreadPool(8);
        for (int i = 0; i < 100; ++i) {
            CountDownLatch latch = new CountDownLatch(8);
            ArrayList<Callable<Object>> runnables = new ArrayList<Callable<Object>>();
            MetaData metaData = new MetaData(new String[]{"org.neo4j.ogm.domain.pizza"});
            for (int j = 0; j < 8; ++j) {
                runnables.add(() -> {
                    FieldInfo fieldInfo = metaData.classInfo(Pizza.class.getName()).getFieldInfo("name");
                    if (fieldInfo != null) {
                        latch.countDown();
                    }
                    return null;
                });
            }
            service.invokeAll(runnables);
            latch.await(1L, TimeUnit.SECONDS);
            AssertionsForClassTypes.assertThat((long)latch.getCount()).isZero();
            logger.info("Metadata init with multiple threads successful");
        }
        service.shutdown();
    }
}

