/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata.reflect;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.annotation.StartNode;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.DomainInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.reflect.EntityAccessManager;

public class AnnotatedFieldWithNoSetterAndNonSetterTest {
    private DomainInfo domainInfo = DomainInfo.create((String[])new String[]{"org.neo4j.ogm.metadata.reflect"});

    @Test
    public void shouldPreferAnnotatedFieldOverNonSetterInAbsenceOfSetterForRelationshipEntity() {
        ClassInfo classInfo = this.domainInfo.getClass(End.class.getName());
        RelEntity relEntity = new RelEntity();
        HashSet<RelEntity> parameter = new HashSet<RelEntity>();
        parameter.addAll(Arrays.asList(relEntity));
        FieldInfo objectAccess = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"REL_ENTITY_TYPE", (String)"INCOMING", (Object)relEntity);
        Assertions.assertThat((Object)objectAccess).as("The resultant object accessor shouldn't be null", new Object[0]).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)(objectAccess instanceof FieldInfo)).as("The access mechanism should be via the field", new Object[0])).isTrue();
        End end = new End();
        objectAccess.write((Object)end, parameter);
        Assertions.assertThat(parameter).isEqualTo(end.getRelEntities());
    }

    static class End {
        Long id;
        String name;
        @Relationship(type="REL_ENTITY_TYPE", direction="INCOMING")
        Set<RelEntity> relEntities = new HashSet<RelEntity>();

        End() {
        }

        Set<RelEntity> getRelEntities() {
            return this.relEntities;
        }
    }

    public static class Start {
        Long id;
        String name;
        @Relationship(type="REL_ENTITY_TYPE", direction="OUTGOING")
        Set<RelEntity> relEntities;
    }

    @RelationshipEntity(type="REL_ENTITY_TYPE")
    public static class RelEntity {
        Long id;
        @StartNode
        Start start;
        @EndNode
        End end;

        public End getEnd() {
            return this.end;
        }

        public void setEnd(End end) {
            this.end = end;
        }

        public Start getStart() {
            return this.start;
        }

        public void setStart(Start start) {
            this.start = start;
        }
    }
}

