/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata.reflect;

import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.ogm.domain.entityMapping.PlainUser;
import org.neo4j.ogm.domain.entityMapping.UserV1;
import org.neo4j.ogm.domain.entityMapping.UserV10;
import org.neo4j.ogm.domain.entityMapping.UserV11;
import org.neo4j.ogm.domain.entityMapping.UserV12;
import org.neo4j.ogm.domain.entityMapping.UserV13;
import org.neo4j.ogm.domain.entityMapping.UserV14;
import org.neo4j.ogm.domain.entityMapping.UserV15;
import org.neo4j.ogm.domain.entityMapping.UserV16;
import org.neo4j.ogm.domain.entityMapping.UserV17;
import org.neo4j.ogm.domain.entityMapping.UserV18;
import org.neo4j.ogm.domain.entityMapping.UserV19;
import org.neo4j.ogm.domain.entityMapping.UserV2;
import org.neo4j.ogm.domain.entityMapping.UserV20;
import org.neo4j.ogm.domain.entityMapping.UserV21;
import org.neo4j.ogm.domain.entityMapping.UserV22;
import org.neo4j.ogm.domain.entityMapping.UserV3;
import org.neo4j.ogm.domain.entityMapping.UserV4;
import org.neo4j.ogm.domain.entityMapping.UserV5;
import org.neo4j.ogm.domain.entityMapping.UserV6;
import org.neo4j.ogm.domain.entityMapping.UserV7;
import org.neo4j.ogm.domain.entityMapping.UserV8;
import org.neo4j.ogm.domain.entityMapping.UserV9;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.DomainInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.reflect.EntityAccessManager;

public class RelationalReaderWriterTest {
    final String KNOWS = "KNOWS";
    final String LIKES = "LIKES";
    private DomainInfo domainInfo;

    @Before
    public void setup() {
        this.domainInfo = DomainInfo.create((String[])new String[]{"org.neo4j.ogm.domain.entityMapping"});
    }

    @Test
    public void testUserV1() {
        String KNOWN_BY = "KNOWN_BY";
        ClassInfo classInfo = this.domainInfo.getClass(UserV1.class.getName());
        UserV1 instance = new UserV1();
        UserV1 relatedObject = new UserV1();
        Assertions.assertThat((Object)EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWN_BY", (String)"OUTGOING")).isNull();
        Assertions.assertThat((Object)EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWN_BY", (String)"OUTGOING", (Object)relatedObject)).isNull();
        FieldInfo relationalReader = EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWN_BY", (String)"INCOMING");
        FieldInfo relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWN_BY", (String)"INCOMING", (Object)relatedObject);
        relationalWriter.write((Object)instance, (Object)relatedObject);
        Assertions.assertThat((Object)instance.getKnownBy()).isEqualTo((Object)relatedObject);
        Assertions.assertThat((Object)relationalReader.read((Object)instance)).isEqualTo((Object)relatedObject);
    }

    @Test
    public void testUserV2() {
        ClassInfo classInfo = this.domainInfo.getClass(UserV2.class.getName());
        UserV2 instance = new UserV2();
        UserV2 relatedObject = new UserV2();
        Assertions.assertThat((Object)EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING")).isNull();
        Assertions.assertThat((Object)EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING", (Object)relatedObject)).isNull();
        FieldInfo relationalReader = EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING");
        FieldInfo relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING", (Object)relatedObject);
        relationalWriter.write((Object)instance, (Object)relatedObject);
        Assertions.assertThat((Object)instance.getKnows()).isEqualTo((Object)relatedObject);
        Assertions.assertThat((Object)relationalReader.read((Object)instance)).isEqualTo((Object)relatedObject);
    }

    @Test
    public void testUserV3() {
        ClassInfo classInfo = this.domainInfo.getClass(UserV3.class.getName());
        UserV3 instance = new UserV3();
        UserV3 relatedObject = new UserV3();
        Assertions.assertThat((Object)EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING")).isNull();
        Assertions.assertThat((Object)EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING", (Object)relatedObject)).isNull();
        FieldInfo relationalReader = EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING");
        FieldInfo relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING", (Object)relatedObject);
        relationalWriter.write((Object)instance, (Object)relatedObject);
        Assertions.assertThat((Object)instance.getFriend()).isEqualTo((Object)relatedObject);
        Assertions.assertThat((Object)relationalReader.read((Object)instance)).isEqualTo((Object)relatedObject);
    }

    @Test
    public void testUserV4() {
        ClassInfo classInfo = this.domainInfo.getClass(UserV4.class.getName());
        UserV4 instance = new UserV4();
        UserV4 relatedObject = new UserV4();
        Assertions.assertThat((Object)EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING")).isNull();
        Assertions.assertThat((Object)EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING", (Object)relatedObject)).isNull();
        FieldInfo relationalReader = EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING");
        FieldInfo relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING", (Object)relatedObject);
        relationalWriter.write((Object)instance, (Object)relatedObject);
        Assertions.assertThat((Object)instance.getFriend()).isEqualTo((Object)relatedObject);
        Assertions.assertThat((Object)relationalReader.read((Object)instance)).isEqualTo((Object)relatedObject);
    }

    @Test
    public void testUserV5() {
        ClassInfo classInfo = this.domainInfo.getClass(UserV5.class.getName());
        UserV5 instance = new UserV5();
        UserV5 relatedObject = new UserV5();
        Assertions.assertThat((Object)EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING")).isNull();
        Assertions.assertThat((Object)EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING", (Object)relatedObject)).isNull();
        FieldInfo relationalReader = EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING");
        FieldInfo relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING", (Object)relatedObject);
        relationalWriter.write((Object)instance, (Object)relatedObject);
        Assertions.assertThat((Object)instance.getFriend()).isEqualTo((Object)relatedObject);
        Assertions.assertThat((Object)relationalReader.read((Object)instance)).isEqualTo((Object)relatedObject);
    }

    @Test
    public void testUserV6() {
        ClassInfo classInfo = this.domainInfo.getClass(UserV6.class.getName());
        UserV6 instance = new UserV6();
        UserV6 relatedObject = new UserV6();
        FieldInfo relationalReader = EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING");
        FieldInfo relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING", (Object)relatedObject);
        relationalReader = EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING");
        relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING", (Object)relatedObject);
        relationalWriter.write((Object)instance, (Object)relatedObject);
        Assertions.assertThat((Object)instance.getKnowsPerson()).isEqualTo((Object)relatedObject);
        Assertions.assertThat((Object)relationalReader.read((Object)instance)).isEqualTo((Object)relatedObject);
    }

    @Test
    public void testUserV7() {
        ClassInfo classInfo = this.domainInfo.getClass(UserV7.class.getName());
        UserV7 instance = new UserV7();
        UserV7 relatedObject = new UserV7();
        Assertions.assertThat((Object)EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING")).isNull();
        Assertions.assertThat((Object)EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING", (Object)relatedObject)).isNull();
        FieldInfo relationalReader = EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING");
        FieldInfo relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING", (Object)relatedObject);
        relationalWriter.write((Object)instance, (Object)relatedObject);
        Assertions.assertThat((Object)instance.getKnows()).isEqualTo((Object)relatedObject);
        Assertions.assertThat((Object)relationalReader.read((Object)instance)).isEqualTo((Object)relatedObject);
    }

    @Test
    public void testUserV8() {
        ClassInfo classInfo = this.domainInfo.getClass(UserV8.class.getName());
        UserV8 instance = new UserV8();
        UserV8 relatedObject = new UserV8();
        Assertions.assertThat((Object)EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING")).isNull();
        Assertions.assertThat((Object)EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING", (Object)relatedObject)).isNull();
        FieldInfo relationalReader = EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING");
        FieldInfo relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING", (Object)relatedObject);
        relationalWriter.write((Object)instance, (Object)relatedObject);
        Assertions.assertThat((Object)instance.getKnows()).isEqualTo((Object)relatedObject);
        Assertions.assertThat((Object)relationalReader.read((Object)instance)).isEqualTo((Object)relatedObject);
    }

    @Test
    public void testUserV9() {
        ClassInfo classInfo = this.domainInfo.getClass(UserV9.class.getName());
        UserV9 instance = new UserV9();
        UserV9 relatedObjectOut = new UserV9();
        UserV9 relatedObjectIn = new UserV9();
        FieldInfo relationalReader = EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"LIKES", (String)"OUTGOING");
        FieldInfo relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"LIKES", (String)"OUTGOING", (Object)relatedObjectOut);
        relationalWriter.write((Object)instance, (Object)relatedObjectOut);
        Assertions.assertThat((Object)instance.getLikes()).isEqualTo((Object)relatedObjectOut);
        Assertions.assertThat((Object)relationalReader.read((Object)instance)).isEqualTo((Object)relatedObjectOut);
        relationalReader = EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"LIKES", (String)"INCOMING");
        relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"LIKES", (String)"INCOMING", (Object)relatedObjectIn);
        relationalWriter.write((Object)instance, (Object)relatedObjectIn);
        Assertions.assertThat((Object)instance.getLikedBy()).isEqualTo((Object)relatedObjectIn);
        Assertions.assertThat((Object)relationalReader.read((Object)instance)).isEqualTo((Object)relatedObjectIn);
    }

    @Test
    public void testUserV10() {
        ClassInfo classInfo = this.domainInfo.getClass(UserV10.class.getName());
        UserV10 instance = new UserV10();
        UserV10 relatedObjectOut = new UserV10();
        UserV10 relatedObjectIn = new UserV10();
        FieldInfo relationalReader = EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"LIKES", (String)"OUTGOING");
        FieldInfo relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"LIKES", (String)"OUTGOING", (Object)relatedObjectOut);
        relationalWriter.write((Object)instance, (Object)relatedObjectOut);
        Assertions.assertThat((Object)instance.getLikes()).isEqualTo((Object)relatedObjectOut);
        Assertions.assertThat((Object)relationalReader.read((Object)instance)).isEqualTo((Object)relatedObjectOut);
        relationalReader = EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"LIKES", (String)"INCOMING");
        relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"LIKES", (String)"INCOMING", (Object)relatedObjectIn);
        relationalWriter.write((Object)instance, (Object)relatedObjectIn);
        Assertions.assertThat((Object)instance.getLikedBy()).isEqualTo((Object)relatedObjectIn);
        Assertions.assertThat((Object)relationalReader.read((Object)instance)).isEqualTo((Object)relatedObjectIn);
    }

    @Test
    public void testUserV11() {
        ClassInfo classInfo = this.domainInfo.getClass(UserV11.class.getName());
        UserV11 instance = new UserV11();
        UserV11 relatedObjectOut = new UserV11();
        UserV11 relatedObjectIn = new UserV11();
        FieldInfo relationalReader = EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"LIKES", (String)"OUTGOING");
        FieldInfo relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"LIKES", (String)"OUTGOING", (Object)relatedObjectOut);
        relationalWriter.write((Object)instance, (Object)relatedObjectOut);
        Assertions.assertThat((Object)instance.getFriend()).isEqualTo((Object)relatedObjectOut);
        Assertions.assertThat((Object)relationalReader.read((Object)instance)).isEqualTo((Object)relatedObjectOut);
        relationalReader = EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"LIKES", (String)"INCOMING");
        relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"LIKES", (String)"INCOMING", (Object)relatedObjectIn);
        relationalWriter.write((Object)instance, (Object)relatedObjectIn);
        Assertions.assertThat((Object)instance.getFriendOf()).isEqualTo((Object)relatedObjectIn);
        Assertions.assertThat((Object)relationalReader.read((Object)instance)).isEqualTo((Object)relatedObjectIn);
    }

    @Test
    public void testUserV12() {
        ClassInfo classInfo = this.domainInfo.getClass(UserV12.class.getName());
        UserV12 instance = new UserV12();
        UserV12 relatedObjectOut = new UserV12();
        UserV12 relatedObjectIn = new UserV12();
        FieldInfo relationalReader = EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"LIKES", (String)"OUTGOING");
        FieldInfo relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"LIKES", (String)"OUTGOING", (Object)relatedObjectOut);
        relationalWriter.write((Object)instance, (Object)relatedObjectOut);
        Assertions.assertThat((Object)instance.getFriend()).isEqualTo((Object)relatedObjectOut);
        Assertions.assertThat((Object)relationalReader.read((Object)instance)).isEqualTo((Object)relatedObjectOut);
        relationalReader = EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"LIKES", (String)"INCOMING");
        relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"LIKES", (String)"INCOMING", (Object)relatedObjectIn);
        relationalWriter.write((Object)instance, (Object)relatedObjectIn);
        Assertions.assertThat((Object)instance.getFriendOf()).isEqualTo((Object)relatedObjectIn);
        Assertions.assertThat((Object)relationalReader.read((Object)instance)).isEqualTo((Object)relatedObjectIn);
    }

    @Test
    public void testUserV13() {
        ClassInfo classInfo = this.domainInfo.getClass(UserV13.class.getName());
        UserV13 instance = new UserV13();
        UserV13 relatedObject = new UserV13();
        Assertions.assertThat((Object)EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING")).isNull();
        Assertions.assertThat((Object)EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING", (Object)relatedObject)).isNull();
        FieldInfo relationalReader = EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING");
        FieldInfo relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING", (Object)relatedObject);
        relationalWriter.write((Object)instance, (Object)relatedObject);
        Assertions.assertThat((Object)instance.getKnows()).isEqualTo((Object)relatedObject);
        Assertions.assertThat((Object)relationalReader.read((Object)instance)).isEqualTo((Object)relatedObject);
    }

    @Test
    public void testUserV14() {
        ClassInfo classInfo = this.domainInfo.getClass(UserV14.class.getName());
        UserV14 instance = new UserV14();
        UserV14 relatedObject = new UserV14();
        Assertions.assertThat((Object)EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING")).isNull();
        Assertions.assertThat((Object)EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING", (Object)relatedObject)).isNull();
        FieldInfo relationalReader = EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING");
        FieldInfo relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING", (Object)relatedObject);
        relationalWriter.write((Object)instance, (Object)relatedObject);
        Assertions.assertThat((Object)instance.knows).isEqualTo((Object)relatedObject);
        Assertions.assertThat((Object)relationalReader.read((Object)instance)).isEqualTo((Object)relatedObject);
    }

    @Test
    public void testUserV15() {
        ClassInfo classInfo = this.domainInfo.getClass(UserV15.class.getName());
        UserV15 instance = new UserV15();
        UserV15 relatedObjectOut = new UserV15();
        UserV15 relatedObjectIn = new UserV15();
        FieldInfo relationalReader = EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING");
        FieldInfo relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING", (Object)relatedObjectOut);
        relationalWriter.write((Object)instance, (Object)relatedObjectOut);
        Assertions.assertThat((Object)instance.getKnows()).isEqualTo((Object)relatedObjectOut);
        Assertions.assertThat((Object)relationalReader.read((Object)instance)).isEqualTo((Object)relatedObjectOut);
        instance = new UserV15();
        relationalReader = EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING");
        relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING", (Object)relatedObjectIn);
        relationalWriter.write((Object)instance, (Object)relatedObjectIn);
        Assertions.assertThat((Object)instance.getKnows()).isEqualTo((Object)relatedObjectIn);
        Assertions.assertThat((Object)relationalReader.read((Object)instance)).isEqualTo((Object)relatedObjectIn);
    }

    @Test
    public void testUserV16() {
        ClassInfo classInfo = this.domainInfo.getClass(UserV16.class.getName());
        UserV16 instance = new UserV16();
        UserV16 relatedObjectOut = new UserV16();
        UserV16 relatedObjectIn = new UserV16();
        FieldInfo relationalReader = EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING");
        FieldInfo relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING", (Object)relatedObjectOut);
        relationalWriter.write((Object)instance, (Object)relatedObjectOut);
        Assertions.assertThat((Object)instance.getKnows()).isEqualTo((Object)relatedObjectOut);
        Assertions.assertThat((Object)relationalReader.read((Object)instance)).isEqualTo((Object)relatedObjectOut);
        instance = new UserV16();
        relationalReader = EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING");
        relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING", (Object)relatedObjectIn);
        relationalWriter.write((Object)instance, (Object)relatedObjectIn);
        Assertions.assertThat((Object)instance.getKnows()).isEqualTo((Object)relatedObjectIn);
        Assertions.assertThat((Object)relationalReader.read((Object)instance)).isEqualTo((Object)relatedObjectIn);
    }

    @Test
    public void testUserV17() {
        ClassInfo classInfo = this.domainInfo.getClass(UserV17.class.getName());
        UserV17 instance = new UserV17();
        UserV17 relatedObject = new UserV17();
        Assertions.assertThat((Object)EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING")).isNull();
        Assertions.assertThat((Object)EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING", (Object)relatedObject)).isNull();
        FieldInfo relationalReader = EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING");
        FieldInfo relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING", (Object)relatedObject);
        relationalWriter.write((Object)instance, (Object)relatedObject);
        Assertions.assertThat((Object)instance.knows).isEqualTo((Object)relatedObject);
        Assertions.assertThat((Object)relationalReader.read((Object)instance)).isEqualTo((Object)relatedObject);
    }

    @Test
    public void testUserV18() {
        ClassInfo classInfo = this.domainInfo.getClass(UserV18.class.getName());
        UserV18 instance = new UserV18();
        UserV18 relatedObject = new UserV18();
        Assertions.assertThat((Object)EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING")).isNull();
        Assertions.assertThat((Object)EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING", (Object)relatedObject)).isNull();
        FieldInfo relationalReader = EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING");
        FieldInfo relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING", (Object)relatedObject);
        relationalWriter.write((Object)instance, (Object)relatedObject);
        Assertions.assertThat((Object)instance.getKnows()).isEqualTo((Object)relatedObject);
        Assertions.assertThat((Object)relationalReader.read((Object)instance)).isEqualTo((Object)relatedObject);
    }

    @Test
    public void testUserV19() {
        ClassInfo classInfo = this.domainInfo.getClass(UserV19.class.getName());
        UserV19 instance = new UserV19();
        UserV19 relatedObject = new UserV19();
        Assertions.assertThat((Object)EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING")).isNull();
        Assertions.assertThat((Object)EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING", (Object)relatedObject)).isNull();
        FieldInfo relationalReader = EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING");
        FieldInfo relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING", (Object)relatedObject);
        relationalWriter.write((Object)instance, (Object)relatedObject);
        Assertions.assertThat((Object)instance.getKnows()).isEqualTo((Object)relatedObject);
        Assertions.assertThat((Object)relationalReader.read((Object)instance)).isEqualTo((Object)relatedObject);
    }

    @Test
    public void testUserV20() {
        ClassInfo classInfo = this.domainInfo.getClass(UserV20.class.getName());
        UserV20 instance = new UserV20();
        UserV20 relatedObject = new UserV20();
        PlainUser otherRelatedObject = new PlainUser();
        Assertions.assertThat((Object)EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING")).isNull();
        Assertions.assertThat((Object)EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING", (Object)relatedObject)).isNull();
        FieldInfo relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING", (Object)relatedObject);
        relationalWriter.write((Object)instance, (Object)relatedObject);
        Assertions.assertThat((Object)instance.getUser()).isEqualTo((Object)relatedObject);
        Assertions.assertThat((Object)EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING", (Object)otherRelatedObject)).isNull();
        relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING", (Object)otherRelatedObject);
        relationalWriter.write((Object)instance, (Object)otherRelatedObject);
        Assertions.assertThat((Object)instance.getPlainUser()).isEqualTo((Object)otherRelatedObject);
    }

    @Test
    public void testUserV21() {
        ClassInfo classInfo = this.domainInfo.getClass(UserV21.class.getName());
        UserV21 instance = new UserV21();
        UserV21 relatedObject = new UserV21();
        PlainUser otherRelatedObject = new PlainUser();
        Assertions.assertThat((Object)EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING")).isNull();
        Assertions.assertThat((Object)EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING", (Object)relatedObject)).isNull();
        FieldInfo relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING", (Object)relatedObject);
        relationalWriter.write((Object)instance, (Object)relatedObject);
        Assertions.assertThat((Object)instance.getUser()).isEqualTo((Object)relatedObject);
        Assertions.assertThat((Object)EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING", (Object)otherRelatedObject)).isNull();
        relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING", (Object)otherRelatedObject);
        relationalWriter.write((Object)instance, (Object)otherRelatedObject);
        Assertions.assertThat((Object)instance.getPlainUser()).isEqualTo((Object)otherRelatedObject);
    }

    @Test
    public void testUserV22() {
        ClassInfo classInfo = this.domainInfo.getClass(UserV22.class.getName());
        UserV22 instance = new UserV22();
        UserV22 relatedObject = new UserV22();
        PlainUser otherRelatedObject = new PlainUser();
        Assertions.assertThat((Object)EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING")).isNull();
        Assertions.assertThat((Object)EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING", (Object)relatedObject)).isNull();
        FieldInfo relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING", (Object)relatedObject);
        relationalWriter.write((Object)instance, (Object)relatedObject);
        Assertions.assertThat((Object)instance.getUser()).isEqualTo((Object)relatedObject);
        Assertions.assertThat((Object)EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"INCOMING", (Object)otherRelatedObject)).isNull();
        relationalWriter = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"KNOWS", (String)"OUTGOING", (Object)otherRelatedObject);
        relationalWriter.write((Object)instance, (Object)otherRelatedObject);
        Assertions.assertThat((Object)instance.getPlainUser()).isEqualTo((Object)otherRelatedObject);
    }
}

