/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata.reflect;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.DomainInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.reflect.EntityAccessManager;

public class RelationshipWriterAnnotatedFieldsTest {
    private DomainInfo domainInfo = DomainInfo.create((String[])new String[]{this.getClass().getPackage().getName()});

    @Test
    public void shouldFindWriterForCollection() {
        ClassInfo classInfo = this.domainInfo.getClass(S.class.getName());
        FieldInfo objectAccess = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"LIST", (String)"OUTGOING", (Object)new T());
        Assertions.assertThat((Object)objectAccess).as("The resultant object accessor shouldn't be null", new Object[0]).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)(objectAccess instanceof FieldInfo)).as("The access mechanism should be via the field", new Object[0])).isTrue();
        Assertions.assertThat((String)objectAccess.relationshipName()).isEqualTo((Object)"LIST");
        Assertions.assertThat((Class)objectAccess.type()).isEqualTo(List.class);
    }

    @Test
    public void shouldFindWriterForScalar() {
        ClassInfo classInfo = this.domainInfo.getClass(S.class.getName());
        FieldInfo objectAccess = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"SCALAR", (String)"OUTGOING", (Object)new T());
        Assertions.assertThat((Object)objectAccess).as("The resultant object accessor shouldn't be null", new Object[0]).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)(objectAccess instanceof FieldInfo)).as("The access mechanism should be via the field", new Object[0])).isTrue();
        Assertions.assertThat((String)objectAccess.relationshipName()).isEqualTo((Object)"SCALAR");
        Assertions.assertThat((Class)objectAccess.type()).isEqualTo(T.class);
    }

    @Test
    public void shouldFindWriterForArray() {
        ClassInfo classInfo = this.domainInfo.getClass(S.class.getName());
        FieldInfo objectAccess = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"ARRAY", (String)"OUTGOING", (Object)new T());
        Assertions.assertThat((Object)objectAccess).as("The resultant object accessor shouldn't be null", new Object[0]).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)(objectAccess instanceof FieldInfo)).as("The access mechanism should be via the field", new Object[0])).isTrue();
        Assertions.assertThat((String)objectAccess.relationshipName()).isEqualTo((Object)"ARRAY");
        Assertions.assertThat((Class)objectAccess.type()).isEqualTo(T[].class);
    }

    private Class getGenericType(Collection<?> collection) {
        if (!collection.isEmpty()) {
            return collection.iterator().next().getClass();
        }
        Class<?> klazz = collection.getClass();
        Type superclass = klazz.getGenericSuperclass();
        try {
            ParameterizedType parameterizedType = (ParameterizedType)superclass;
            Type[] types = parameterizedType.getActualTypeArguments();
            return (Class)types[0];
        }
        catch (Exception e) {
            return null;
        }
    }

    static class T {
        Long id;

        T() {
        }
    }

    static class S {
        Long id;
        @Relationship(type="LIST", direction="OUTGOING")
        List<T> list;
        @Relationship(type="ARRAY", direction="OUTGOING")
        T[] array;
        @Relationship(type="SCALAR", direction="OUTGOING")
        T scalar;

        S() {
        }
    }
}

