/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata.reflect;

import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.DomainInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.reflect.EntityAccessManager;

public class RelationshipWriterPlainFieldsTest {
    private DomainInfo domainInfo = DomainInfo.create((String[])new String[]{this.getClass().getPackage().getName()});

    @Test
    public void shouldFindWriterForCollection() {
        ClassInfo classInfo = this.domainInfo.getClass(S.class.getName());
        FieldInfo objectAccess = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"LIST", (String)"OUTGOING", (Object)new T());
        Assertions.assertThat((Object)objectAccess).as("The resultant object accessor shouldn't be null", new Object[0]).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)(objectAccess instanceof FieldInfo)).as("The access mechanism should be via the field", new Object[0])).isTrue();
        Assertions.assertThat((String)objectAccess.relationshipName()).isEqualTo((Object)"LIST");
    }

    @Test
    public void shouldFindWriterForScalar() {
        ClassInfo classInfo = this.domainInfo.getClass(S.class.getName());
        FieldInfo objectAccess = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"SCALAR", (String)"OUTGOING", (Object)new T());
        Assertions.assertThat((Object)objectAccess).as("The resultant object accessor shouldn't be null", new Object[0]).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)(objectAccess instanceof FieldInfo)).as("The access mechanism should be via the field", new Object[0])).isTrue();
        Assertions.assertThat((String)objectAccess.relationshipName()).isEqualTo((Object)"SCALAR");
    }

    @Test
    public void shouldFindWriterForArray() {
        ClassInfo classInfo = this.domainInfo.getClass(S.class.getName());
        FieldInfo objectAccess = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"ARRAY", (String)"OUTGOING", (Object)new T());
        Assertions.assertThat((Object)objectAccess).as("The resultant object accessor shouldn't be null", new Object[0]).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)(objectAccess instanceof FieldInfo)).as("The access mechanism should be via the field", new Object[0])).isTrue();
        Assertions.assertThat((String)objectAccess.relationshipName()).isEqualTo((Object)"ARRAY");
    }

    static class T {
        Long id;

        T() {
        }
    }

    static class S {
        Long id;
        List<T> list;
        T[] array;
        T scalar;

        S() {
        }
    }
}

