/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.bike;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.domain.bike.Bike;
import org.neo4j.ogm.domain.bike.Wheel;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.persistence.examples.bike.BikeRequest;
import org.neo4j.ogm.session.Neo4jSession;

public class BikeTest {
    private static MetaData metadata = new MetaData(new String[]{"org.neo4j.ogm.domain.bike"});
    private static Neo4jSession session = new Neo4jSession(metadata, (Driver)new BikeRequest());

    @Test
    public void testDeserialiseBikeModel() throws Exception {
        Collection bikes = session.loadAll(Bike.class);
        Assertions.assertThat((boolean)bikes.isEmpty()).isFalse();
        Bike bike = (Bike)bikes.iterator().next();
        Assertions.assertThat((Object)bike).isNotNull();
        Assertions.assertThat((long)bike.getId()).isEqualTo(15L);
        Assertions.assertThat((int)bike.getColours().length).isEqualTo(2);
        Assertions.assertThat((long)bike.getFrame().getId()).isEqualTo(18L);
        Assertions.assertThat((int)bike.getFrame().getSize()).isEqualTo(27);
        Assertions.assertThat((long)bike.getSaddle().getId()).isEqualTo(19L);
        Assertions.assertThat((Double)bike.getSaddle().getPrice()).isCloseTo(42.99, Assertions.within((Double)0.0));
        Assertions.assertThat((String)bike.getSaddle().getMaterial()).isEqualTo((Object)"plastic");
        Assertions.assertThat(bike.getWheels()).hasSize(2);
        for (Wheel wheel : bike.getWheels()) {
            if (wheel.getId().equals(16L)) {
                Assertions.assertThat((int)wheel.getSpokes()).isEqualTo(3);
            }
            if (!wheel.getId().equals(17L)) continue;
            Assertions.assertThat((int)wheel.getSpokes()).isEqualTo(5);
        }
    }

    @Test
    public void testReloadExistingDomain() {
        Collection bikes = session.loadAll(Bike.class);
        Collection theSameBikes = session.loadAll(Bike.class);
        Assertions.assertThat((int)theSameBikes.size()).isEqualTo(bikes.size());
    }
}

