/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.blog;

import java.io.Serializable;
import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.domain.blog.Author;
import org.neo4j.ogm.domain.blog.Comment;
import org.neo4j.ogm.domain.blog.Post;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class BlogTest
extends MultiDriverTestClass {
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.blog"});
    }

    @Before
    public void init() {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void shouldTraverseListOfBlogPosts() {
        Post p1 = new Post("first");
        Post p2 = new Post("second");
        Post p3 = new Post("third");
        Post p4 = new Post("fourth");
        p1.setNext(p2);
        p2.setNext(p3);
        p3.setNext(p4);
        Assertions.assertThat((Object)p2.getPrevious()).isEqualTo((Object)p1);
        Assertions.assertThat((Object)p1.getNext()).isEqualTo((Object)p2);
        Assertions.assertThat((Object)p3.getPrevious()).isEqualTo((Object)p2);
        Assertions.assertThat((Object)p2.getNext()).isEqualTo((Object)p3);
        Assertions.assertThat((Object)p4.getPrevious()).isEqualTo((Object)p3);
        Assertions.assertThat((Object)p3.getNext()).isEqualTo((Object)p4);
        Assertions.assertThat((Object)p4.getNext()).isNull();
        this.session.save((Object)p1);
        this.session.clear();
        Post f3 = (Post)this.session.load(Post.class, (Serializable)p3.getId(), -1);
        Post f2 = f3.getPrevious();
        Post f1 = f2.getPrevious();
        Post f4 = f3.getNext();
        Assertions.assertThat((Object)f1.getPrevious()).isNull();
        Assertions.assertThat((Long)f2.getPrevious().getId()).isEqualTo((Object)p1.getId());
        Assertions.assertThat((Long)f3.getPrevious().getId()).isEqualTo((Object)p2.getId());
        Assertions.assertThat((Long)f4.getPrevious().getId()).isEqualTo((Object)p3.getId());
        Assertions.assertThat((Long)f1.getNext().getId()).isEqualTo((Object)p2.getId());
        Assertions.assertThat((Long)f2.getNext().getId()).isEqualTo((Object)p3.getId());
        Assertions.assertThat((Long)f3.getNext().getId()).isEqualTo((Object)p4.getId());
        Assertions.assertThat((Object)f4.getNext()).isNull();
    }

    @Test
    public void shouldDeleteAuthoredRelationship() {
        Author author = new Author();
        Post post = new Post();
        author.posts = new HashSet<Post>();
        author.posts.add(post);
        this.session.save((Object)author);
        this.session.clear();
        author = (Author)this.session.load(Author.class, (Serializable)author.id);
        author.posts.clear();
        this.session.save((Object)author);
        this.session.clear();
        author = (Author)this.session.load(Author.class, (Serializable)author.id);
        Assertions.assertThat((author.posts == null || author.posts.size() == 0 ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void shouldDeleteCommentsRelationship() {
        Author author = new Author();
        Post post = new Post();
        Comment comment = new Comment(post, author, "Try to delete me!");
        author.posts = new HashSet<Post>();
        author.posts.add(post);
        author.comments.add(comment);
        this.session.save((Object)author);
        this.session.clear();
        author = (Author)this.session.load(Author.class, (Serializable)author.id);
        author.comments.clear();
        this.session.save((Object)author);
        this.session.clear();
        author = (Author)this.session.load(Author.class, (Serializable)author.id);
        Assertions.assertThat((author.comments == null || author.comments.size() == 0 ? 1 : 0) != 0).isTrue();
    }
}

