/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.cineasts.annotated;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.cypher.query.SortOrder;
import org.neo4j.ogm.domain.cineasts.annotated.Actor;
import org.neo4j.ogm.domain.cineasts.annotated.Knows;
import org.neo4j.ogm.domain.cineasts.annotated.Movie;
import org.neo4j.ogm.domain.cineasts.annotated.Rating;
import org.neo4j.ogm.domain.cineasts.annotated.Role;
import org.neo4j.ogm.domain.cineasts.annotated.User;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.session.Utils;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.neo4j.ogm.testutil.TestUtils;

public class CineastsRelationshipEntityTest
extends MultiDriverTestClass {
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.cineasts.annotated"});
    }

    @Before
    public void init() {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void shouldSaveMultipleRatingsFromDifferentUsersForSameMovie() {
        Movie movie = new Movie("Pulp Fiction", 1994);
        this.session.save((Object)movie);
        User michal = new User();
        michal.setName("Michal");
        michal.setLogin("bachmania");
        Rating awesome = new Rating();
        awesome.setMovie(movie);
        awesome.setUser(michal);
        awesome.setStars(5);
        michal.setRatings(Collections.singleton(awesome));
        this.session.save((Object)michal);
        Collection films = this.session.loadAll(Movie.class, new Filter("title", ComparisonOperator.EQUALS, (Object)"Pulp Fiction"));
        Assertions.assertThat((Iterable)films).hasSize(1);
        Movie film = (Movie)films.iterator().next();
        Assertions.assertThat((Object)film).isNotNull();
        Assertions.assertThat(film.getRatings()).hasSize(1);
        Assertions.assertThat((String)film.getRatings().iterator().next().getUser().getName()).isEqualTo((Object)"Michal");
        User luanne = new User();
        luanne.setName("luanne");
        luanne.setLogin("luanne");
        luanne.setPassword("luanne");
        Rating rating = new Rating();
        rating.setMovie(film);
        rating.setUser(luanne);
        rating.setStars(3);
        luanne.setRatings(Collections.singleton(rating));
        this.session.save((Object)luanne);
        films = this.session.loadAll(Movie.class, new Filter("title", ComparisonOperator.EQUALS, (Object)"Pulp Fiction"));
        film = (Movie)films.iterator().next();
        Assertions.assertThat(film.getRatings()).hasSize(2);
        User foundLuanne = (User)this.session.load(User.class, (Serializable)((Object)"luanne"));
        Assertions.assertThat(foundLuanne.getRatings()).hasSize(1);
        Collection users = this.session.loadAll(User.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"Michal"));
        User foundMichal = (User)users.iterator().next();
        Assertions.assertThat(foundMichal.getRatings()).hasSize(1);
    }

    @Test
    public void shouldCreateREWithExistingStartAndEndNodes() {
        this.bootstrap("org/neo4j/ogm/cql/cineasts.cql");
        Collection films = this.session.loadAll(Movie.class, new Filter("title", ComparisonOperator.EQUALS, (Object)"Top Gear"));
        Movie movie = (Movie)films.iterator().next();
        Assertions.assertThat(movie.getRatings()).hasSize(2);
        User michal = null;
        for (Rating rating : movie.getRatings()) {
            if (!rating.getUser().getName().equals("Michal")) continue;
            michal = rating.getUser();
            break;
        }
        Assertions.assertThat(michal).isNotNull();
        HashSet<Rating> ratings = new HashSet<Rating>();
        Rating awesome = new Rating();
        awesome.setComment("Awesome");
        awesome.setMovie(movie);
        awesome.setUser(michal);
        awesome.setStars(5);
        ratings.add(awesome);
        michal.setRatings(ratings);
        movie.setRatings(ratings);
        this.session.save((Object)movie);
        Collection movies = this.session.loadAll(Movie.class, new Filter("title", ComparisonOperator.EQUALS, (Object)"Top Gear"));
        movie = (Movie)movies.iterator().next();
        Assertions.assertThat(movie.getRatings()).isNotNull();
        Assertions.assertThat(movie.getRatings()).hasSize(1);
        Assertions.assertThat((String)movie.getRatings().iterator().next().getUser().getName()).isEqualTo((Object)"Michal");
    }

    @Test
    public void shouldNotLoseRelationshipEntitiesWhenALoadedEntityIsPersisted() {
        this.bootstrap("org/neo4j/ogm/cql/cineasts.cql");
        Movie topGear = (Movie)this.session.loadAll(Movie.class, new Filter("title", ComparisonOperator.EQUALS, (Object)"Top Gear")).iterator().next();
        Assertions.assertThat(topGear.getRatings()).hasSize(2);
        this.session.save((Object)topGear);
        topGear = (Movie)this.session.loadAll(Movie.class, new Filter("title", ComparisonOperator.EQUALS, (Object)"Top Gear")).iterator().next();
        Assertions.assertThat(topGear.getRatings()).hasSize(2);
        User michal = (User)this.session.loadAll(User.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"Michal")).iterator().next();
        Assertions.assertThat(michal.getRatings()).hasSize(2);
    }

    @Test
    public void shouldLoadActorsForAPersistedMovie() {
        this.session.query("CREATE (dh:Movie {title:'Die Hard'}), (bw:Actor {name: 'Bruce Willis'}), (bw)-[:ACTS_IN {role : 'John'}]->(dh)", Utils.map((Object[])new Object[0]));
        Movie dieHard = (Movie)this.session.loadAll(Movie.class).iterator().next();
        Assertions.assertThat((Object)dieHard).isNotNull();
        Assertions.assertThat(dieHard.getRoles()).isNotNull();
        Assertions.assertThat(dieHard.getRoles()).hasSize(1);
    }

    @Test
    public void shouldBeAbleToModifyRating() {
        Movie movie = new Movie("Harry Potter and the Philosophers Stone", 2003);
        User vince = new User();
        vince.setName("Vince");
        vince.setLogin("bickerv");
        HashSet<Rating> ratings = new HashSet<Rating>();
        Rating awesome = new Rating();
        awesome.setComment("Awesome");
        awesome.setMovie(movie);
        awesome.setUser(vince);
        awesome.setStars(5);
        ratings.add(awesome);
        vince.setRatings(ratings);
        movie.setRatings(ratings);
        this.session.save((Object)movie);
        Collection movies = this.session.loadAll(Movie.class, new Filter("title", ComparisonOperator.EQUALS, (Object)"Harry Potter and the Philosophers Stone"));
        movie = (Movie)movies.iterator().next();
        Assertions.assertThat(movie.getRatings()).hasSize(1);
        Rating rating = movie.getRatings().iterator().next();
        Assertions.assertThat((String)rating.getUser().getName()).isEqualTo((Object)"Vince");
        Assertions.assertThat((int)rating.getStars()).isEqualTo(5);
        rating.setStars(3);
        this.session.save((Object)rating);
        this.session.clear();
        movies = this.session.loadAll(Movie.class, new Filter("title", ComparisonOperator.EQUALS, (Object)"Harry Potter and the Philosophers Stone"));
        movie = (Movie)movies.iterator().next();
        Assertions.assertThat(movie.getRatings()).hasSize(1);
        rating = movie.getRatings().iterator().next();
        Assertions.assertThat((String)rating.getUser().getName()).isEqualTo((Object)"Vince");
        Assertions.assertThat((int)rating.getStars()).isEqualTo(3);
        vince = rating.getUser();
        movie.getRatings().iterator().next().setStars(2);
        this.session.save((Object)vince);
        this.session.clear();
        movies = this.session.loadAll(Movie.class, new Filter("title", ComparisonOperator.EQUALS, (Object)"Harry Potter and the Philosophers Stone"));
        movie = (Movie)movies.iterator().next();
        Assertions.assertThat(movie.getRatings()).hasSize(1);
        rating = movie.getRatings().iterator().next();
        Assertions.assertThat((String)rating.getUser().getName()).isEqualTo((Object)"Vince");
        Assertions.assertThat((int)rating.getStars()).isEqualTo(2);
        movie.getRatings().iterator().next().setStars(1);
        this.session.save((Object)movie);
        this.session.clear();
        movies = this.session.loadAll(Movie.class, new Filter("title", ComparisonOperator.EQUALS, (Object)"Harry Potter and the Philosophers Stone"));
        movie = (Movie)movies.iterator().next();
        Assertions.assertThat(movie.getRatings()).hasSize(1);
        rating = movie.getRatings().iterator().next();
        Assertions.assertThat((String)rating.getUser().getName()).isEqualTo((Object)"Vince");
        Assertions.assertThat((int)rating.getStars()).isEqualTo(1);
    }

    @Test
    public void shouldSaveRelationshipEntityWithCamelCaseStartEndNodes() {
        Actor bruce = new Actor("Bruce");
        Actor jim = new Actor("Jim");
        Knows knows = new Knows();
        knows.setFirstActor(bruce);
        knows.setSecondActor(jim);
        knows.setSince(new Date());
        bruce.getKnows().add(knows);
        this.session.save((Object)bruce);
        Actor actor = (Actor)TestUtils.firstOrNull((Iterable)this.session.loadAll(Actor.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"Bruce")));
        Assertions.assertThat((Object)actor).isNotNull();
        Assertions.assertThat(actor.getKnows()).hasSize(1);
        Assertions.assertThat((String)actor.getKnows().iterator().next().getSecondActor().getName()).isEqualTo((Object)"Jim");
    }

    @Test
    public void shouldSaveAndRetrieveRelationshipEntitiesDirectly() {
        this.session.query("CREATE (nc:NotAClass {name:'Colin'}), (g:NotAClass {age: 39}), (g)-[:TEST {comment : 'test'}]->(nc)", Utils.map((Object[])new Object[0]));
        User critic = new User();
        critic.setName("Gary");
        critic.setLogin("gman");
        Movie film = new Movie("Fast and Furious XVII", 2015);
        Rating filmRating = new Rating();
        filmRating.setUser(critic);
        critic.setRatings(Collections.singleton(filmRating));
        filmRating.setMovie(film);
        film.setRatings(Collections.singleton(filmRating));
        filmRating.setStars(2);
        filmRating.setComment("They've made far too many of these films now!");
        this.session.save((Object)filmRating);
        Rating loadedRating = (Rating)this.session.load(Rating.class, (Serializable)filmRating.getId());
        Assertions.assertThat((Object)loadedRating).as("The loaded rating shouldn't be null", new Object[0]).isNotNull();
        ((AbstractIntegerAssert)Assertions.assertThat((int)loadedRating.getStars()).as("The relationship properties weren't saved correctly", new Object[0])).isEqualTo(filmRating.getStars());
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)loadedRating.getMovie().getTitle()).as("The rated film wasn't saved correctly", new Object[0])).isEqualTo((Object)film.getTitle());
        ((AbstractLongAssert)Assertions.assertThat((Long)loadedRating.getUser().getId()).as("The critic wasn't saved correctly", new Object[0])).isEqualTo((Object)critic.getId());
    }

    @Test
    public void shouldSaveAndRetrieveRelationshipEntitiesPreExistingDirectly() {
        this.session.query("CREATE (ff:Movie {title:'Fast and Furious XVII'}), (g:User {name: 'Gary'}), (g)-[:RATED {comment : 'Too many of these films!'}]->(ff)", Utils.map((Object[])new Object[0]));
        Rating loadedRating = (Rating)this.session.loadAll(Rating.class).iterator().next();
        Assertions.assertThat((Object)loadedRating).as("The loaded rating shouldn't be null", new Object[0]).isNotNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)loadedRating.getMovie().getTitle()).as("The rated film wasn't saved correctly", new Object[0])).isEqualTo((Object)"Fast and Furious XVII");
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)loadedRating.getUser().getName()).as("The critic wasn't saved correctly", new Object[0])).isEqualTo((Object)"Gary");
    }

    @Test
    public void shouldBeAbleToSaveAndUpdateMultipleUserRatings() {
        HashSet<Rating> gobletRatings = new HashSet<Rating>();
        HashSet<Rating> phoenixRatings = new HashSet<Rating>();
        Movie goblet = new Movie("Harry Potter and the Goblet of Fire", 2006);
        this.session.save((Object)goblet);
        Movie phoenix = new Movie("Harry Potter and the Order of the Phoenix", 2009);
        this.session.save((Object)phoenix);
        User adam = new User();
        adam.setName("Adam");
        adam.setLogin("adamg");
        Rating good = new Rating();
        good.setUser(adam);
        good.setMovie(goblet);
        good.setStars(3);
        gobletRatings.add(good);
        goblet.setRatings(gobletRatings);
        Rating okay = new Rating();
        okay.setMovie(phoenix);
        okay.setUser(adam);
        okay.setStars(2);
        phoenixRatings.add(okay);
        phoenix.setRatings(phoenixRatings);
        HashSet<Rating> adamsRatings = new HashSet<Rating>();
        adamsRatings.add(good);
        adamsRatings.add(okay);
        adam.setRatings(adamsRatings);
        this.session.save((Object)adam);
        Collection movies = this.session.loadAll(Movie.class, new Filter("title", ComparisonOperator.EQUALS, (Object)"Harry Potter and the Goblet of Fire"));
        goblet = (Movie)movies.iterator().next();
        Assertions.assertThat(goblet.getRatings()).isNotNull();
        Assertions.assertThat(goblet.getRatings()).hasSize(1);
        movies = this.session.loadAll(Movie.class, new Filter("title", ComparisonOperator.EQUALS, (Object)"Harry Potter and the Order of the Phoenix"));
        phoenix = (Movie)movies.iterator().next();
        Assertions.assertThat(phoenix.getRatings()).isNotNull();
        Assertions.assertThat(phoenix.getRatings()).hasSize(1);
        adam = (User)this.session.loadAll(User.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"Adam")).iterator().next();
        Assertions.assertThat(adam.getRatings()).hasSize(2);
        adam.setRatings(gobletRatings);
        this.session.save((Object)adam);
        adam = (User)this.session.loadAll(User.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"Adam")).iterator().next();
        Assertions.assertThat(adam.getRatings()).hasSize(1);
        movies = this.session.loadAll(Movie.class, new Filter("title", ComparisonOperator.EQUALS, (Object)"Harry Potter and the Order of the Phoenix"));
        phoenix = (Movie)movies.iterator().next();
        Assertions.assertThat(phoenix.getRatings()).isNull();
        movies = this.session.loadAll(Movie.class, new Filter("title", ComparisonOperator.EQUALS, (Object)"Harry Potter and the Goblet of Fire"));
        goblet = (Movie)movies.iterator().next();
        Assertions.assertThat(goblet.getRatings()).isNotNull();
        Assertions.assertThat(goblet.getRatings()).hasSize(1);
    }

    @Test
    public void shouldBeAbleToDeleteAllRatings() {
        HashSet<Rating> gobletRatings = new HashSet<Rating>();
        HashSet<Rating> phoenixRatings = new HashSet<Rating>();
        Movie goblet = new Movie("Harry Potter and the Goblet of Fire", 2006);
        this.session.save((Object)goblet);
        Movie phoenix = new Movie("Harry Potter and the Order of the Phoenix", 2009);
        this.session.save((Object)phoenix);
        User adam = new User();
        adam.setName("Adam");
        adam.setLogin("adamg");
        Rating good = new Rating();
        good.setUser(adam);
        good.setMovie(goblet);
        good.setStars(3);
        gobletRatings.add(good);
        goblet.setRatings(gobletRatings);
        Rating okay = new Rating();
        okay.setMovie(phoenix);
        okay.setUser(adam);
        okay.setStars(2);
        phoenixRatings.add(okay);
        phoenix.setRatings(phoenixRatings);
        HashSet<Rating> adamsRatings = new HashSet<Rating>();
        adamsRatings.add(good);
        adamsRatings.add(okay);
        adam.setRatings(adamsRatings);
        this.session.save((Object)adam);
        adam = (User)this.session.loadAll(User.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"Adam")).iterator().next();
        Assertions.assertThat(adam.getRatings()).hasSize(2);
        this.session.deleteAll(Rating.class);
        Assertions.assertThat((Iterable)this.session.loadAll(Rating.class)).isEmpty();
        phoenix = (Movie)this.session.loadAll(Movie.class, new Filter("title", ComparisonOperator.EQUALS, (Object)"Harry Potter and the Order of the Phoenix")).iterator().next();
        Assertions.assertThat(phoenix.getRatings()).isNull();
        goblet = (Movie)this.session.loadAll(Movie.class, new Filter("title", ComparisonOperator.EQUALS, (Object)"Harry Potter and the Goblet of Fire")).iterator().next();
        Assertions.assertThat(goblet.getRatings()).isNull();
        adam = (User)this.session.loadAll(User.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"Adam")).iterator().next();
        Assertions.assertThat(adam.getRatings()).isNull();
    }

    @Test
    public void shouldBeAbleToDeleteOneRating() {
        HashSet<Rating> gobletRatings = new HashSet<Rating>();
        HashSet<Rating> phoenixRatings = new HashSet<Rating>();
        Movie goblet = new Movie("Harry Potter and the Goblet of Fire", 2006);
        this.session.save((Object)goblet);
        Movie phoenix = new Movie("Harry Potter and the Order of the Phoenix", 2009);
        this.session.save((Object)phoenix);
        User adam = new User();
        adam.setName("Adam");
        adam.setLogin("adamg");
        Rating good = new Rating();
        good.setUser(adam);
        good.setMovie(goblet);
        good.setStars(3);
        gobletRatings.add(good);
        goblet.setRatings(gobletRatings);
        Rating okay = new Rating();
        okay.setMovie(phoenix);
        okay.setUser(adam);
        okay.setStars(2);
        phoenixRatings.add(okay);
        phoenix.setRatings(phoenixRatings);
        HashSet<Rating> adamsRatings = new HashSet<Rating>();
        adamsRatings.add(good);
        adamsRatings.add(okay);
        adam.setRatings(adamsRatings);
        this.session.save((Object)adam);
        adam = (User)this.session.loadAll(User.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"Adam")).iterator().next();
        Assertions.assertThat(adam.getRatings()).hasSize(2);
        this.session.delete((Object)okay);
        Collection ratings = this.session.loadAll(Rating.class);
        Assertions.assertThat((Iterable)ratings).hasSize(1);
        phoenix = (Movie)this.session.loadAll(Movie.class, new Filter("title", ComparisonOperator.EQUALS, (Object)"Harry Potter and the Order of the Phoenix")).iterator().next();
        Assertions.assertThat(phoenix.getRatings()).isNull();
        goblet = (Movie)this.session.loadAll(Movie.class, new Filter("title", ComparisonOperator.EQUALS, (Object)"Harry Potter and the Goblet of Fire")).iterator().next();
        Assertions.assertThat(goblet.getRatings()).hasSize(1);
        adam = (User)this.session.loadAll(User.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"Adam")).iterator().next();
        Assertions.assertThat(adam.getRatings()).hasSize(1);
    }

    @Test
    public void shouldSaveRelationshipEntityWithNullProperty() {
        Actor bruce = new Actor("Bruce");
        Actor jim = new Actor("Jim");
        Knows knows = new Knows();
        knows.setFirstActor(bruce);
        knows.setSecondActor(jim);
        bruce.getKnows().add(knows);
        this.session.save((Object)bruce);
        Actor actor = (Actor)TestUtils.firstOrNull((Iterable)this.session.loadAll(Actor.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"Bruce")));
        Assertions.assertThat((Object)actor).isNotNull();
        Assertions.assertThat(actor.getKnows()).hasSize(1);
        Assertions.assertThat((String)actor.getKnows().iterator().next().getSecondActor().getName()).isEqualTo((Object)"Jim");
        bruce.getKnows().iterator().next().setSince(new Date());
        this.session.save((Object)bruce);
        actor = (Actor)TestUtils.firstOrNull((Iterable)this.session.loadAll(Actor.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"Bruce")));
        Assertions.assertThat(actor.getKnows()).hasSize(1);
        Assertions.assertThat((Date)actor.getKnows().iterator().next().getSince()).isNotNull();
        bruce.getKnows().iterator().next().setSince(null);
        this.session.save((Object)bruce);
        actor = (Actor)TestUtils.firstOrNull((Iterable)this.session.loadAll(Actor.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"Bruce")));
        Assertions.assertThat(actor.getKnows()).hasSize(1);
        Assertions.assertThat((Date)actor.getKnows().iterator().next().getSince()).isNull();
    }

    @Test
    public void shouldLoadRelationshipEntityWithSameStartEndNodeType() {
        Actor bruce = new Actor("Bruce");
        Actor jim = new Actor("Jim");
        Knows knows = new Knows();
        knows.setFirstActor(bruce);
        knows.setSecondActor(jim);
        knows.setSince(new Date());
        bruce.getKnows().add(knows);
        this.session.save((Object)bruce);
        this.session.clear();
        Actor actor = (Actor)TestUtils.firstOrNull((Iterable)this.session.loadAll(Actor.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"Bruce")));
        Assertions.assertThat((Object)actor).isNotNull();
        Assertions.assertThat(actor.getKnows()).hasSize(1);
        Assertions.assertThat((String)actor.getKnows().iterator().next().getFirstActor().getName()).isEqualTo((Object)"Bruce");
        Assertions.assertThat((String)actor.getKnows().iterator().next().getSecondActor().getName()).isEqualTo((Object)"Jim");
    }

    @Test
    public void shouldHydrateTheEndNodeOfAnRECorrectly() {
        Movie movie = new Movie("Pulp Fiction", 1994);
        Actor actor = new Actor("John Travolta");
        actor.playedIn(movie, "Vincent");
        this.session.save((Object)movie);
        User michal = new User();
        michal.setName("Michal");
        michal.setLogin("bachmania");
        Rating awesome = new Rating();
        awesome.setMovie(movie);
        awesome.setUser(michal);
        awesome.setStars(5);
        michal.setRatings(Collections.singleton(awesome));
        this.session.save((Object)michal);
        Collection films = this.session.loadAll(Movie.class, new Filter("title", ComparisonOperator.EQUALS, (Object)"Pulp Fiction"));
        Assertions.assertThat((Iterable)films).hasSize(1);
        Movie film = (Movie)films.iterator().next();
        Assertions.assertThat((Object)film).isNotNull();
        Assertions.assertThat(film.getRatings()).hasSize(1);
        Assertions.assertThat((String)film.getRatings().iterator().next().getUser().getName()).isEqualTo((Object)"Michal");
        Assertions.assertThat((String)film.getRoles().iterator().next().getRole()).isEqualTo((Object)"Vincent");
        this.session.clear();
        Rating rating = (Rating)this.session.load(Rating.class, (Serializable)awesome.getId(), 2);
        Assertions.assertThat((Object)rating).isNotNull();
        Movie loadedMovie = rating.getMovie();
        Assertions.assertThat((Object)loadedMovie).isNotNull();
        Assertions.assertThat((String)loadedMovie.getTitle()).isEqualTo((Object)"Pulp Fiction");
        Assertions.assertThat((String)loadedMovie.getRoles().iterator().next().getRole()).isEqualTo((Object)"Vincent");
    }

    @Test
    public void shouldSaveMultipleRoleRelationshipsBetweenTheSameTwoObjects() {
        Movie movie = new Movie("The big John Travolta Party", 2016);
        Actor actor = new Actor("John Travolta");
        for (int i = 65; i <= 90; ++i) {
            String role = new String(new char[]{(char)i});
            actor.playedIn(movie, role);
        }
        Assertions.assertThat(actor.getRoles()).hasSize(26);
        this.session.save((Object)actor);
        this.session.clear();
        Actor loadedActor = (Actor)this.session.load(Actor.class, (Serializable)actor.getUuid());
        Assertions.assertThat(loadedActor.getRoles()).hasSize(26);
    }

    @Test
    public void shouldSaveSameRoleTwiceRelationshipBetweenTheSameTwoObjects() {
        Movie movie = new Movie("The big John Travolta Party", 2016);
        Actor actor = new Actor("John Travolta");
        actor.playedIn(movie, "He danced mostly");
        Assertions.assertThat(actor.getRoles()).hasSize(1);
        this.session.save((Object)actor);
        this.session.clear();
        Actor loadedActor = (Actor)this.session.load(Actor.class, (Serializable)actor.getUuid());
        Assertions.assertThat(loadedActor.getRoles()).hasSize(1);
        actor.playedIn(movie, "He danced mostly");
        Assertions.assertThat(actor.getRoles()).hasSize(2);
        this.session.save((Object)actor);
        this.session.clear();
        loadedActor = (Actor)this.session.load(Actor.class, (Serializable)actor.getUuid());
        Assertions.assertThat(loadedActor.getRoles()).hasSize(2);
    }

    @Test
    public void updateRoleToSameValueResultsInTwoRelationshipBetweenSameObjects() throws Exception {
        Movie movie = new Movie("The big John Travolta Party", 2016);
        Actor actor = new Actor("John Travolta");
        Role role1 = actor.playedIn(movie, "He danced mostly");
        Role role2 = actor.playedIn(movie, "He was dancing mostly");
        Assertions.assertThat(actor.getRoles()).hasSize(2);
        this.session.save((Object)actor);
        this.session.clear();
        Actor loaded = (Actor)this.session.load(Actor.class, (Serializable)actor.getUuid());
        Assertions.assertThat(loaded.getRoles()).hasSize(2);
        role2.setRole("He danced mostly");
        this.session.save((Object)actor);
        this.session.clear();
        loaded = (Actor)this.session.load(Actor.class, (Serializable)actor.getUuid());
        Assertions.assertThat(loaded.getRoles()).hasSize(2);
    }

    @Test
    public void shouldRetainREsWhenAStartOrEndNodeIsLoaded() {
        this.bootstrap("org/neo4j/ogm/cql/cineasts.cql");
        Collection films = this.session.loadAll(Movie.class, new Filter("title", ComparisonOperator.EQUALS, (Object)"Top Gear"));
        Movie movie = (Movie)films.iterator().next();
        Assertions.assertThat(movie.getRatings()).hasSize(2);
        this.session.loadAll(User.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"Michal")).iterator().next();
        Assertions.assertThat(movie.getRatings()).hasSize(2);
    }

    @Test
    public void shouldLoadFilmsByTitleUsingCaseInsensitiveWildcardBasedLikeExpression() {
        Movie firstFilm = new Movie("Dirty Harry", 1977);
        Movie secondFilm = new Movie("Harry Potter and the Order of the Phoenix", 2009);
        Movie thirdFilm = new Movie("Delhi Belly", 2012);
        this.session.save((Object)firstFilm);
        this.session.save((Object)secondFilm);
        this.session.save((Object)thirdFilm);
        Filter filter = new Filter("title", ComparisonOperator.LIKE, (Object)"harry*");
        Collection allFilms = this.session.loadAll(Movie.class, filter);
        ((IterableAssert)Assertions.assertThat((Iterable)allFilms).as("The wrong-sized collection of films was returned", new Object[0])).hasSize(1);
        Assertions.assertThat((String)((Movie)allFilms.iterator().next()).getTitle()).isEqualTo((Object)"Harry Potter and the Order of the Phoenix");
    }

    @Test
    public void shouldLoadASingleRating() {
        Movie movie = new Movie("Pulp Fiction", 1994);
        this.session.save((Object)movie);
        User michal = new User();
        michal.setName("Michal");
        michal.setLogin("bachmania");
        Rating awesome = new Rating();
        awesome.setMovie(movie);
        awesome.setUser(michal);
        awesome.setStars(5);
        michal.setRatings(Collections.singleton(awesome));
        this.session.save((Object)michal);
        User luanne = new User();
        luanne.setName("luanne");
        luanne.setLogin("luanne");
        luanne.setPassword("luanne");
        Rating rating = new Rating();
        rating.setMovie(movie);
        rating.setUser(luanne);
        rating.setStars(3);
        luanne.setRatings(Collections.singleton(rating));
        this.session.save((Object)luanne);
        this.session.clear();
        Rating loadedRating = (Rating)this.session.load(Rating.class, (Serializable)rating.getId(), 3);
        Assertions.assertThat((Object)loadedRating).isNotNull();
        Assertions.assertThat((Long)loadedRating.getId()).isEqualTo((Object)rating.getId());
        Assertions.assertThat((int)loadedRating.getStars()).isEqualTo(rating.getStars());
    }

    @Test
    public void shouldSortRatings() {
        Movie movie = new Movie("Pulp Fiction", 1994);
        this.session.save((Object)movie);
        User michal = new User();
        michal.setName("Michal");
        michal.setLogin("bachmania");
        Rating awesome = new Rating();
        awesome.setMovie(movie);
        awesome.setUser(michal);
        awesome.setStars(5);
        michal.setRatings(Collections.singleton(awesome));
        this.session.save((Object)michal);
        User luanne = new User();
        luanne.setName("luanne");
        luanne.setLogin("luanne");
        luanne.setPassword("luanne");
        Rating rating = new Rating();
        rating.setMovie(movie);
        rating.setUser(luanne);
        rating.setStars(3);
        luanne.setRatings(Collections.singleton(rating));
        this.session.save((Object)luanne);
        this.session.clear();
        Collection ratings = this.session.loadAll(Rating.class, new SortOrder().add(SortOrder.Direction.ASC, new String[]{"stars"}));
        Assertions.assertThat((Iterable)ratings).isNotNull();
        int i = 0;
        for (Rating r : ratings) {
            if (i++ == 0) {
                Assertions.assertThat((int)r.getStars()).isEqualTo(3);
                continue;
            }
            Assertions.assertThat((int)r.getStars()).isEqualTo(5);
        }
    }

    @Test
    public void shouldBeAbleToSetREPropertiesToNull() throws MalformedURLException {
        Movie movie = new Movie("Pulp Fiction", 1994);
        this.session.save((Object)movie);
        User michal = new User();
        michal.setName("Michal");
        michal.setLogin("bachmania");
        Rating awesome = new Rating();
        awesome.setMovie(movie);
        awesome.setUser(michal);
        awesome.setStars(5);
        awesome.setComment("Just awesome");
        michal.setRatings(Collections.singleton(awesome));
        this.session.save((Object)michal);
        awesome.setComment(null);
        this.session.save((Object)awesome);
        awesome = (Rating)this.session.load(Rating.class, (Serializable)awesome.getId());
        Assertions.assertThat((String)awesome.getComment()).isNull();
        Assertions.assertThat((int)awesome.getStars()).isEqualTo(5);
        this.session.clear();
        awesome = (Rating)this.session.load(Rating.class, (Serializable)awesome.getId());
        Assertions.assertThat((String)awesome.getComment()).isNull();
        Assertions.assertThat((int)awesome.getStars()).isEqualTo(5);
        this.session.clear();
        movie = (Movie)this.session.load(Movie.class, (Serializable)movie.getUuid());
        Assertions.assertThat(movie.getRatings()).hasSize(1);
        Assertions.assertThat((String)movie.getRatings().iterator().next().getComment()).isNull();
    }

    @Test
    public void testFilterOnRelationshipEntity() throws Exception {
        Movie pulpFiction = new Movie("Pulp Fiction", 1994);
        Movie ootf = new Movie("Harry Potter and the Order of the Phoenix", 2009);
        User frantisek = new User();
        frantisek.setName("Frantisek");
        frantisek.setLogin("frantisek");
        Rating pulpRating = new Rating();
        pulpRating.setStars(3);
        pulpRating.setMovie(pulpFiction);
        pulpRating.setUser(frantisek);
        pulpFiction.setRatings(new HashSet<Rating>(Arrays.asList(pulpRating)));
        Rating ootfRating = new Rating();
        ootfRating.setStars(3);
        ootfRating.setMovie(ootf);
        ootfRating.setUser(frantisek);
        frantisek.setRatings(new HashSet<Rating>(Arrays.asList(ootfRating, pulpRating)));
        User otto = new User();
        otto.setName("Otto");
        otto.setLogin("otto");
        Rating pulpRating2 = new Rating();
        pulpRating2.setStars(3);
        pulpRating2.setMovie(pulpFiction);
        pulpRating2.setUser(otto);
        Rating ootfRating2 = new Rating();
        ootfRating2.setStars(3);
        ootfRating2.setMovie(ootf);
        ootfRating2.setUser(otto);
        pulpFiction.setRatings(new HashSet<Rating>(Arrays.asList(pulpRating, pulpRating2)));
        ootf.setRatings(new HashSet<Rating>(Arrays.asList(ootfRating, ootfRating2)));
        otto.setRatings(new HashSet<Rating>(Arrays.asList(pulpRating2, ootfRating2)));
        this.session.save((Object)otto);
        this.session.clear();
        Filter filter = new Filter("stars", ComparisonOperator.EQUALS, (Object)3);
        filter.setNestedPropertyName("ratings");
        filter.setNestedPropertyType(Rating.class);
        filter.setNestedRelationshipEntity(true);
        Collection users = this.session.loadAll(User.class, filter, new Pagination(0, 2));
        Assertions.assertThat((Iterable)users).hasSize(2);
    }

    @Test
    public void testFilterOnRelatedNode() throws Exception {
        User frantisek = new User();
        frantisek.setName("Frantisek");
        frantisek.setLogin("frantisek");
        User michal = new User();
        michal.setName("Michal");
        michal.setLogin("michal");
        User ottoH = new User();
        ottoH.setName("Otto");
        ottoH.setLogin("otto");
        User ottoB = new User();
        ottoB.setName("Otto von Bismarc");
        ottoB.setLogin("ottob");
        frantisek.addFriends(ottoH, ottoB);
        this.session.save((Object)frantisek);
        michal.addFriends(ottoH, ottoB);
        this.session.save((Object)michal);
        Filter filter = new Filter("name", ComparisonOperator.CONTAINING, (Object)"Otto");
        filter.setNestedPropertyName("friends");
        filter.setNestedPropertyType(User.class);
        SortOrder sortOrder = new SortOrder();
        sortOrder.add(new String[]{"name"});
        Collection users = this.session.loadAll(User.class, filter, sortOrder, new Pagination(0, 2));
        Assertions.assertThat((Iterable)users).hasSize(2);
    }

    private void bootstrap(String cqlFileName) {
        this.session.query(TestUtils.readCQLFile((String)cqlFileName).toString(), Utils.map((Object[])new Object[0]));
    }
}

