/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.cineasts.partial;

import java.io.Serializable;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.domain.cineasts.minimum.Actor;
import org.neo4j.ogm.domain.cineasts.minimum.Movie;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class RelationshipEntityPartialMappingTest
extends MultiDriverTestClass {
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.cineasts.minimum"});
    }

    @Before
    public void init() {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void testCreateAndReloadActorRoleAndMovie() {
        Actor keanu = new Actor("Keanu Reeves");
        Movie matrix = new Movie("The Matrix");
        keanu.addRole("Neo", matrix);
        this.session.save((Object)keanu);
        Actor keanu2 = (Actor)this.session.load(Actor.class, (Serializable)keanu.getId());
        Assertions.assertThat(keanu2.roles()).hasSize(1);
    }

    @Test
    public void testCreateAndReloadActorMultipleRolesAndMovies() {
        Actor keanu = new Actor("Keanu Reeves");
        Movie matrix = new Movie("The Matrix");
        Movie speed = new Movie("Speed");
        keanu.addRole("Neo", matrix);
        keanu.addRole("Jack Traven", speed);
        this.session.save((Object)keanu);
        Actor keanu2 = (Actor)this.session.load(Actor.class, (Serializable)keanu.getId());
        Assertions.assertThat(keanu2.roles()).hasSize(2);
        keanu2.addRole("John Constantine", new Movie("Constantine"));
        this.session.save((Object)keanu2);
        Actor keanu3 = (Actor)this.session.load(Actor.class, (Serializable)keanu2.getId());
        Assertions.assertThat(keanu3.roles()).hasSize(3);
    }

    @Test
    public void testCreateAndDeleteActorMultipleRolesAndMovies() {
        Actor keanu = new Actor("Keanu Reeves");
        Movie matrix = new Movie("The Matrix");
        Movie hp = new Movie("Harry Potter");
        keanu.addRole("Neo", matrix);
        keanu.addRole("Dumbledore", hp);
        this.session.save((Object)keanu);
        Actor keanu2 = (Actor)this.session.load(Actor.class, (Serializable)keanu.getId());
        Assertions.assertThat(keanu2.roles()).hasSize(2);
        keanu2.removeRole("Dumbledore");
        this.session.save((Object)keanu2);
        Actor keanu3 = (Actor)this.session.load(Actor.class, (Serializable)keanu2.getId());
        Assertions.assertThat(keanu3.roles()).hasSize(1);
    }
}

